/* kb.h
 * $Id: kb.h,v 0.7 1999/03/11 07:16:42 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define MAX_TREE_DEPTH	256	/* Maximum depth of the KB tree */
#define MAX_STR_LEN	512	/* Maximum length of arbitrary strings
				 * (e.g. filenames */
#define MAX_DESC_LEN	4096	/* Maximum length of descriptions */

#define DATA(str, dlg)		(gtk_object_get_data (GTK_OBJECT (dlg), str))
#define TEXT_DATA(str, dlg)	(gtk_entry_get_text (GTK_ENTRY (DATA \
				(str, dlg))))
#define KB_ITEM_SELECTED	(GTK_TREE(tree_kb)->selection->data)

struct _node {
	GString *name;
	GString *description;
	GString *filename;
};

typedef struct _node node;

/* Stores the actual KB. Woo hoo, global! */
extern GtkWidget *tree_kb;

extern void new_root_node	(void);
extern void read_kbfile		(void);
extern gint read_tree_items	(gint indent, GtkWidget *subtree, FILE *ptr);
extern void write_kbfile	(void);
extern void write_node		(FILE *ptr, GtkWidget *tree, gint indent);
extern void on_tree_item_click (GtkObject *tree_item, GdkEventButton *event,
		gpointer func_data);
extern node *new_node		(void);
extern void free_node		(node *);
