/* kb.c
 * $Id: kb.c,v 0.12 1999/03/11 07:15:55 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

/* Stores the actual KB. Woo hoo, global! */
GtkWidget *tree_kb;

/* Creates a new root node. Assumes that tree_kb's item has already been
 * deleted. */
void new_root_node (){
        GtkWidget       *kb_item;
        node            *node_ptr;

	/* Create a root node */
	kb_item = gtk_tree_item_new_with_label (_("KB root"));
        debug_msg("new root node created = 0x%x\n" __ (gint)kb_item);

	node_ptr = new_node ();
	(void) g_string_assign (node_ptr -> name, _("KB root"));
	gtk_object_set_data (GTK_OBJECT (kb_item), "node",
			(gpointer)node_ptr);
	gtk_tree_append (GTK_TREE (tree_kb), kb_item);
	gtk_widget_show (kb_item);
	(void) gtk_signal_connect (GTK_OBJECT (kb_item),
				   "button_press_event", GTK_SIGNAL_FUNC
				   (on_tree_item_click), NULL);
}

/* Perhaps more error-checking could be done or more lenient rules
 * enforced.
 *
 * Call this AFTER create_window_main, which sets up tree_kb.
 * Some of this function may be redundant, but oh well.
 * I should check this for bugs more thoroughly, but it seems to work. */
void read_kbfile(void){
	gchar		*kbfile;
	FILE		*ptr;
	gint		ret;

        debug_msg("reading kb file\n");

	kbfile = g_strconcat (g_get_home_dir (), KBFILE, NULL);

        debug_msg("opening %s\n" __ kbfile);
	ptr = fopen (kbfile, "rt");
	free (kbfile);
	if (ptr == NULL){
		debug_msg("unsuccessful file open\n");
		new_root_node();
	} else {
		debug_msg("successful file open\n");
		(void) fscanf	(ptr, "%d", &ret);
		(void) fgetc	(ptr);	/* Read ONE newline */
		/* Start at depth 0, hopefully. */
		g_assert (ret == 0);
		ret = read_tree_items(0, tree_kb, ptr);
		g_assert(ret == -1);
	}
}

/* Given that we are at tree depth "depth", children of "subtree", read
   tree items from "ptr" */
gint read_tree_items (gint depth, GtkWidget *subtree, FILE *ptr){
	gint		indent, desc_len, ret;
	gchar		*tmpstr;
	node		*node_ptr;
	GtkWidget	*kb_item = NULL, *new_subtree;

	debug_msg("reading at depth %d\n" __ depth);

	/* We assume the indentation has already been read. */
	ret = depth;
	tmpstr = g_malloc (sizeof (gchar) * MAX_STR_LEN);
	while (feof (ptr) == 0){
		/* If we have not already read the indentation (at a
		 * higher depth) */
		if(ret == -1){
			(void) fscanf	(ptr, "%d", &indent);
			(void) fgetc	(ptr);	/* Read ONE newline */
			g_assert (indent <= depth+1);
		} else {
			indent = ret;
			ret = -1;
		}
		debug_msg("reading at indent %d\n" __ indent);
		g_assert(indent < MAX_TREE_DEPTH);
		/* If proper indentation, read the node and put it in
		 * the tree */
		if (indent == depth){
			debug_msg ("reading the node\n");
			node_ptr = new_node ();

			/* Get the name */
			(void) fgets (tmpstr, MAX_STR_LEN, ptr);
			/* Overwrite the final newline with NULL. */
			tmpstr = g_strchomp (tmpstr);
			(void) g_string_assign (node_ptr -> name, tmpstr);

			/* Get the description */
			(void) fscanf (ptr, "%d", &desc_len);
			(void) fgetc (ptr);	/* Read ONE newline */
			g_assert (desc_len < MAX_DESC_LEN);
			/* Silly little hack follows */
			tmpstr[0] = (gchar)0;
			do{
				(void) fgets (tmpstr + strlen(tmpstr),
					      MAX_DESC_LEN -
					      strlen(tmpstr), ptr);
			} while (strlen (tmpstr) - 1 < desc_len);
			/* Overwrite the final newline with NULL. */
			tmpstr = g_strchomp (tmpstr);
			g_assert ((gint) strlen (tmpstr) == desc_len);
			(void) g_string_assign (node_ptr -> description,
						tmpstr);

			/* Get the filename */
			(void) fgets (tmpstr, MAX_STR_LEN, ptr);
			/* Overwrite the final newline with NULL. */
			tmpstr = g_strchomp (tmpstr);
			(void) g_string_assign (node_ptr -> filename,
						tmpstr);

			/* Read the trailing newline */
			(void) fscanf(ptr, "\n");

			kb_item = gtk_tree_item_new_with_label (node_ptr
					-> name -> str);
			gtk_object_set_data (GTK_OBJECT (kb_item),
					"node",
					(gpointer)node_ptr);
			gtk_tree_append (GTK_TREE (subtree), kb_item);
			(void) gtk_signal_connect (GTK_OBJECT (kb_item),
						   "button_press_event",
						   GTK_SIGNAL_FUNC
						   (on_tree_item_click),
						   NULL);
		} else if (indent == depth + 1) {
			debug_msg("reading child\n");
			g_assert (kb_item != NULL);
			new_subtree = gtk_tree_new ();
			gtk_tree_item_set_subtree (GTK_TREE_ITEM (kb_item),
                                new_subtree);
			gtk_tree_item_expand (GTK_TREE_ITEM (kb_item));

			ret = read_tree_items (indent, new_subtree, ptr);
			if(ret < depth){
				gtk_widget_show_all (subtree);
				free (tmpstr);
				return ret;
			}
		} else if (indent < depth) {
			debug_msg("falling back\n");
			gtk_widget_show_all (subtree);
			free (tmpstr);
			return indent;
		} else {
			/* What the fuck?!?!? */
			g_error (_("what the fuck?!?!?\n"
"Please send a bug report to kibble@wish.student.harvard.edu\n"));
			g_assert (0);
		}
	}
	gtk_widget_show_all (subtree);
	free (tmpstr);
	return -1;
}

void write_kbfile (void){
	gchar *kbfile;
	FILE *ptr;

        kbfile = g_strconcat (g_get_home_dir (), KBFILE, NULL);

	debug_msg ("writing %s\n" __ kbfile);
	ptr = fopen (kbfile, "wt");
	if(!ptr){
		g_error (_("Could not open kb file %s for writing."), kbfile);
	}

	write_node (ptr, tree_kb, 0);
	(void) fclose(ptr);
}

void write_node (FILE *ptr, GtkWidget *tree, gint indent){
	GList	*glistptr;
	node	*tree_node;

	g_assert(indent < MAX_TREE_DEPTH);
	debug_msg("writing tree item at depth %d\n" __ indent);
	if(tree){
		glistptr = GTK_TREE(tree)->children;
		while(glistptr){
			/* Depth first search the tree */
			tree_node = gtk_object_get_data (GTK_OBJECT
					(glistptr->data), "node");
			g_assert(tree_node->description->len	< MAX_DESC_LEN);
			g_assert(tree_node->name->len		< MAX_STR_LEN);
			g_assert(tree_node->filename->len	< MAX_STR_LEN);
			fprintf(ptr, "%d\n%s\n%d\n%s\n%s\n\n",
					indent,
					tree_node->name->str,
					tree_node->description->len,
					tree_node->description->str,
					tree_node->filename->str);

			write_node(ptr, GTK_TREE_ITEM_SUBTREE (glistptr->data),
					indent+1);
			glistptr = glistptr->next;
		}
	}
}

void on_tree_item_click (GtkObject *tree_item, GdkEventButton *event,
		gpointer func_data)
{
        debug_msg("tree item 0x%x clicked\n" __ (gint)tree_item);

	if (event->type==GDK_2BUTTON_PRESS && event->button==1){
		debug_msg("left button double click\n");
		/* A strange little hack. */
		gtk_tree_select_child (GTK_TREE (tree_kb), GTK_WIDGET
				(tree_item));
		on_view_activate(NULL, NULL);
		gtk_tree_select_child (GTK_TREE (tree_kb), GTK_WIDGET
				(tree_item));
	}
}

node *new_node (void)
{
	node *node_ptr;

	node_ptr = g_malloc ((gulong) sizeof (node));
	debug_msg("creating new node 0x%x\n" __ (gint)node_ptr);
	if (node_ptr != NULL) {
		node_ptr -> name	= g_string_new ("");
		node_ptr -> description	= g_string_new ("");
		node_ptr -> filename	= g_string_new ("");
	} else { g_assert (node_ptr != NULL); }
	/* If we have this little memory, we're fucked anyhow */

	return (node_ptr);
}

void free_node (node *node_ptr)
{
	/* What about "node_ptr -> name";
	 * "node_ptr -> description";
	 * "node_ptr -> filename"; */
	debug_msg("freeing node 0x%x\n" __ (gint)node_ptr);
	g_free(node_ptr);
}
