/* delete_dialog.c
 * $Id: delete_dialog.c,v 0.9 1999/03/11 07:15:55 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

static void on_button_delete_okay_clicked (GtkButton *button,
		gpointer user_data)
{
	GtkWidget *dialog_delete;
	GtkWidget *current_tree_item;

	debug_msg("delete okay clicked\n");

	dialog_delete = user_data;
	g_assert (GTK_IS_WINDOW (dialog_delete) != 0);

	current_tree_item = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT 
				(dialog_delete), "tree item"));
	g_assert (current_tree_item != NULL);
	if (GTK_IS_TREE_ITEM (current_tree_item) != 1) {
		show_message_box (_("Error!\n\n"
				"Tree item no longer exists?\n"
				"Aborting delete operation\n"));
		gtk_object_destroy (GTK_OBJECT (dialog_delete));
		return;
	}

	if (current_tree_item == GTK_TREE(tree_kb)->children->data)
		new_root_node();

	/* Probably should release the subordinate nodes' malloc'ed
	 * mem. This is the cheesy cop-out way to delete the node */
	/* I should get around to using free_node */
	debug_msg("removing 0x%x\n" __ (gint)current_tree_item);
	gtk_widget_destroy (GTK_WIDGET (current_tree_item));
	gtk_object_destroy (GTK_OBJECT (dialog_delete));
}

void create_dialog_delete ()
{
	GtkWidget *dialog_delete;
	GtkWidget *dialog_vbox;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *dialog_action_area;
	GtkWidget *hbox;
	GtkWidget *button_okay;
	GtkWidget *button_cancel;

	debug_msg ("creating delete dialog\n");
	dialog_delete = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (dialog_delete), "tree item",
			KB_ITEM_SELECTED);
	debug_msg ("dialog_delete = 0x%x\n" __ (gint)dialog_delete);
	gtk_window_set_title (GTK_WINDOW (dialog_delete), _("Delete"));
	gtk_window_set_policy (GTK_WINDOW (dialog_delete), TRUE, TRUE, FALSE);

	dialog_vbox = GTK_DIALOG (dialog_delete)->vbox;
	gtk_container_border_width (GTK_CONTAINER (dialog_vbox), 10);

	vbox = gtk_vbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), vbox, TRUE, TRUE, 0);

	label = gtk_label_new (_("Are you sure that you want\n"
				"to delete this node\n"
				"and all of its subtrees?\n"));
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);

	dialog_action_area = GTK_DIALOG (dialog_delete)->action_area;
	gtk_container_border_width (GTK_CONTAINER (dialog_action_area), 10);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (dialog_action_area), hbox, TRUE, TRUE, 0);

	button_okay = gtk_button_new_with_label (_("Okay"));
	gtk_box_pack_start (GTK_BOX (hbox), button_okay, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS (button_okay, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect (GTK_OBJECT (button_okay), "clicked",
				   GTK_SIGNAL_FUNC
				   (on_button_delete_okay_clicked),
				   GTK_OBJECT (dialog_delete));

	button_cancel = gtk_button_new_with_label (_("Cancel"));
	gtk_box_pack_start (GTK_BOX (hbox), button_cancel, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);
	gtk_widget_grab_focus (button_cancel);
	gtk_widget_grab_default (button_cancel);
	(void) gtk_signal_connect_object (GTK_OBJECT (button_cancel),
					  "clicked", GTK_SIGNAL_FUNC
					  (gtk_object_destroy), GTK_OBJECT
					  (dialog_delete));

	g_assert (GTK_OBJECT (dialog_delete) != GTK_OBJECT (button_cancel));
	gtk_widget_show_all (dialog_delete);
}
