/* data_selectfile.c
 * $Id: data_selectfile.c,v 0.8 1999/03/11 07:15:55 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

/* Points to the text entry that is updated */
GtkWidget *entry_filename;

/* Opens the filesection_data window */
void on_button_browse_clicked (GtkButton *button, gpointer user_data){
	debug_msg("browse button clicked\n");
	create_fileselection_data ();
}

void on_button_data_okay_clicked (GtkObject *dialog, gpointer user_data){
        gtk_entry_set_text (GTK_ENTRY (entry_filename),
		gtk_file_selection_get_filename(GTK_FILE_SELECTION
			(dialog)));
	gtk_widget_show (entry_filename);

	debug_msg("data okay clicked, dialog = 0x%x, user_data = 0x%x\n" _
			(gint)dialog __ (gint)user_data);
        if(GTK_IS_WINDOW(dialog) != 0)
                gtk_object_destroy (GTK_OBJECT(dialog));
        else
                gtk_object_destroy (GTK_OBJECT(user_data));
}

void create_fileselection_data ()
{
	GtkWidget *fileselection_data;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;

	fileselection_data = gtk_file_selection_new (_("Select File"));
	debug_msg("fileselection created = 0x%x\n" __ (gint)fileselection_data);
	gtk_object_set_data (GTK_OBJECT (fileselection_data),
			"fileselection_data", fileselection_data);
	gtk_container_border_width (GTK_CONTAINER (fileselection_data), 10);

	ok_button = GTK_FILE_SELECTION (fileselection_data)->ok_button;
	GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
			GTK_SIGNAL_FUNC (on_button_data_okay_clicked),
			GTK_OBJECT (fileselection_data));

	cancel_button = GTK_FILE_SELECTION (fileselection_data)->cancel_button;
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect_object (GTK_OBJECT (cancel_button),
					  "clicked", GTK_SIGNAL_FUNC
					  (gtk_object_destroy), GTK_OBJECT
					  (fileselection_data));
	gtk_widget_show_all (fileselection_data);
}
