/* add_dialog.c
 * $Id: add_dialog.c,v 0.15 1999/03/11 07:15:55 joseph Exp $
 */

/* kibble
 * Copyright (C) 1999, Joseph Turian
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "all.h"

static void on_button_add_okay_clicked (GtkButton *button, gpointer user_data)
{
	node *new_data;
	GtkWidget *dialog_add;
	GtkWidget *current_tree_item;
	GtkWidget *subtree, *new_item;

        debug_msg ("add okay button clicked\n");

	dialog_add = user_data;
	g_assert (GTK_IS_WINDOW (dialog_add) != 0);

	current_tree_item = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT
				(dialog_add), "tree item"));
	g_assert (current_tree_item != NULL);
	if (GTK_IS_TREE_ITEM (current_tree_item) != 1) {
		show_message_box (_("Error!\n\n"
				"Tree item no longer exists?\n"
				"Aborting add operation\n"));
		gtk_object_destroy (GTK_OBJECT (dialog_add));
		return;
	}
	
	/* If no other subtree */
	if(!(subtree = GTK_TREE_ITEM_SUBTREE(current_tree_item))){
		debug_msg ("no subtree, creating new one\n");
		subtree = gtk_tree_new();
		gtk_tree_item_set_subtree (GTK_TREE_ITEM (current_tree_item),
				subtree);
		gtk_tree_item_expand (GTK_TREE_ITEM (current_tree_item));
	}

	new_data = new_node();
	(void *) g_string_assign (new_data->name, TEXT_DATA ("name", dialog_add));
	(void *) g_string_assign (new_data->description, gtk_editable_get_chars
			(GTK_EDITABLE (DATA ("description", dialog_add)),
			 0, (gint)gtk_text_get_length (GTK_TEXT (DATA
					 ("description", dialog_add)))));

	(void *) g_string_assign (new_data->filename, TEXT_DATA ("filename",
				dialog_add));

	new_item = gtk_tree_item_new_with_label (new_data->name->str);
	gtk_object_set_data (GTK_OBJECT (new_item), "node", (gpointer)new_data);
	gtk_tree_append (GTK_TREE(subtree), new_item);
	(void) gtk_signal_connect (GTK_OBJECT (new_item),
			"button_press_event",
			GTK_SIGNAL_FUNC (on_tree_item_click),
			NULL);

	gtk_widget_show_all (current_tree_item);
	gtk_widget_show (subtree);
	gtk_widget_show (new_item);
	gtk_object_destroy (GTK_OBJECT (dialog_add));
}

void create_dialog_add ()
{
	GtkWidget *dialog_add;
	GtkWidget *dialog_vbox;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *entry_name;
	GtkWidget *text_description;
	GtkWidget *frame;
	GtkWidget *button_view;
	GtkWidget *button_browse;
	GtkWidget *dialog_action_area;
	GtkWidget *button_okay;
	GtkWidget *button_cancel;

	debug_msg ("creating add dialog\n");
	dialog_add = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (dialog_add), "tree item",
			KB_ITEM_SELECTED);
	debug_msg ("dialog_add = 0x%x\n" __ (gint)dialog_add);
	gtk_window_set_title (GTK_WINDOW (dialog_add), "Add");
	gtk_window_set_policy (GTK_WINDOW (dialog_add), TRUE, TRUE, FALSE);

	dialog_vbox = GTK_DIALOG (dialog_add)->vbox;

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), vbox, TRUE, TRUE, 5);
	gtk_container_border_width (GTK_CONTAINER (vbox), 10);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 3);

	label = gtk_label_new (_("Name:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	entry_name = gtk_entry_new_with_max_length (MAX_STR_LEN);
	gtk_object_set_data (GTK_OBJECT (dialog_add), "name", entry_name);
	gtk_box_pack_start (GTK_BOX (hbox), entry_name, TRUE, TRUE, 5);
	GTK_WIDGET_SET_FLAGS (entry_name, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (entry_name);

	label = gtk_label_new (_("Description:"));
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	text_description = gtk_text_new (NULL, NULL);
	gtk_object_set_data (GTK_OBJECT (dialog_add), "description", text_description);
	gtk_box_pack_start (GTK_BOX (vbox), text_description, TRUE, TRUE, 5);
	GTK_WIDGET_SET_FLAGS (text_description, GTK_CAN_DEFAULT);
	gtk_text_set_editable (GTK_TEXT (text_description), 1);
	/* What is the difference? */
	gtk_text_set_line_wrap (GTK_TEXT (text_description), 1);
	gtk_text_set_word_wrap (GTK_TEXT (text_description), 1);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 3);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER (hbox), 5);

	label = gtk_label_new (_("Filename:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);

	entry_filename = gtk_entry_new_with_max_length (MAX_STR_LEN);
	gtk_object_set_data (GTK_OBJECT (dialog_add), "filename",
			entry_filename);
	gtk_box_pack_start (GTK_BOX (hbox), entry_filename, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

	button_view = gtk_button_new_with_label (_("View"));
	gtk_box_pack_start (GTK_BOX (hbox), button_view, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS (button_view, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect (GTK_OBJECT (button_view), "clicked",
			GTK_SIGNAL_FUNC (not_implemented),
			NULL);

	button_browse = gtk_button_new_with_label (_("Browse"));
	gtk_box_pack_start (GTK_BOX (hbox), button_browse, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS (button_browse, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect (GTK_OBJECT (button_browse), "clicked",
			GTK_SIGNAL_FUNC (on_button_browse_clicked),
			NULL);

	dialog_action_area = GTK_DIALOG (dialog_add)->action_area;
	gtk_container_border_width (GTK_CONTAINER (dialog_action_area), 10);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (dialog_action_area), hbox, TRUE, TRUE, 0);

	button_okay = gtk_button_new_with_label (_("Okay"));
	gtk_box_pack_start (GTK_BOX (hbox), button_okay, TRUE, FALSE, 5);
	GTK_WIDGET_SET_FLAGS (button_okay, GTK_CAN_DEFAULT);
	gtk_widget_grab_focus (button_okay);
	gtk_widget_grab_default (button_okay);
	(void) gtk_signal_connect (GTK_OBJECT (button_okay), "clicked",
			GTK_SIGNAL_FUNC (on_button_add_okay_clicked),
			GTK_OBJECT (dialog_add));

	button_cancel = gtk_button_new_with_label (_("Cancel"));
	gtk_box_pack_start (GTK_BOX (hbox), button_cancel, TRUE, FALSE, 5);
	gtk_container_border_width (GTK_CONTAINER (button_cancel), 1);
	GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);
	(void) gtk_signal_connect_object (GTK_OBJECT (button_cancel),
					  "clicked", GTK_SIGNAL_FUNC
					  (gtk_object_destroy), GTK_OBJECT
					  (dialog_add));
	gtk_widget_show_all (dialog_add);
}
