/* 
 *  Edit dates.lst - with ncurses interface
 *
 *  AUTHOR : Fabio Menegoni 
 *  VERSION: 0.0.3
 *
 */

/*
	Copyright (C) 1997  Marco Rivellino & Fabio Menegoni

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef DA_EDIT_H
#define DA_EDIT_H

#include "config.h"

#include <form.h>
#include <stdio.h>

/* headers && footers && delete string*/
#define DA_HEADER	" Dates Editor"
#define DA_FOOTER	" F1 - Help "
#define DA_FORM_HEADER	" Date        Type    L.D. Comment"
#define DA_HELP_HEADER	" Any key to exit... "
#define DA_DELETE_TAG	"*** DELETED ***"

/* various size */
#define FIELD_PER_ROW	8
#define MAXFIELD	(MAXROW*FIELD_PER_ROW+1)
#define ROW_FROM_BOTTOM 5
#define TMPSIZE		80

/* functions exit codes */
#define DA_E_OK		0
#define DA_E_OPEN_R	1
#define DA_E_OPEN_W	2
#define DA_E_CURSES	3
#define DA_E_FORMAT	4
#define DA_E_NO_ROOM	5
#define DA_E_SYSTEM_ERROR	6
#define DA_E_WRITE		7
#define DA_E_REQ_OK		8
#define DA_E_REQ_CANCEL		9
#define DA_E_REQ_NO_ROOM	10
#define DA_E_BAD_ARGUMENT	11
#define DA_E_FILE_EMPTY		12
#define DA_E_NO_REQ_TYPE	13

/* default colors */
#define BG_COLOR		1
#define TITLE_COLOR		2
#define BOTTOM_LINE_COLOR	3
#define ACTIVE_COLOR		4
#define INACTIVE_COLOR		5

/* misc ... */
#ifndef CTRL
#define CTRL(x)		((x) & 0x1f)
#endif


struct elem {
	struct date_entry *de;
	struct elem *next;
};


/* function prototypes */
extern int start_curses();
extern int end_curses();

extern int edit_data_file(char *filename, int editmode);

extern int form_readl(FILE *istream, FIELD **f, struct elem **e, int editmode);
extern int form_writel(FILE *ostream, FORM *form, struct elem **e);

extern int de_2_form_row(FIELD **f, struct date_entry *de, int row);
extern int form_changed(FORM *form);
extern int form_row_de_sync(FORM *form);
extern struct date_entry *form_row_2_de(FORM *form, int row);
extern struct date_entry *form_row_de(FORM *form, int row);

extern FIELD *make_label(int frow, int fcol, char *label);
extern FIELD *make_field(int frow, int fcol, int rows, int cols);

extern int mk_stdscr(char *header, char *footer);

extern int display_form(FORM *form, char *title);
extern int erase_form(FORM *form);
extern int form_virtualize(WINDOW *w);

extern int requester(char *message, char *ok, char *cancel);

extern int row_insert(FORM *form);
extern int row_add(FORM *form);
extern int row_delete(FORM *form);
extern int row_undo(FORM *form);
extern int row_move(FIELD **f, int dest_row, int src_row);
extern int form_into_pages(FIELD **f);

extern int form_validate(FORM *form, int *wrong_row);

extern char *curs_error(int e);
extern struct date_entry *default_de();
extern int help_win();

extern struct elem *list_cons(struct elem *e, struct date_entry *de);
extern struct elem *list_ord_cons(struct elem *e, struct date_entry *de);
int list_free(struct elem *e);
int list_find(struct elem *e, struct date_entry *de);

void sig_catch(int signo);

int form_row_hl(FORM *form, int on);


#endif		/* DA_EDIT_H */
