/*---------------------------------------------------------------------------
  Name:		dates.h
  Version:	0.7
  Internal:	4
  Date:		27 may 97
  Author:	Marco Rivellino

  Description:	declaration of the exportable funcions of module dates.c

---------------------------------------------------------------------------*/
/*
    Copyright (C) 1997  Marco Rivellino & Fabio Menegoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DA_DATES_H
#define DA_DATES_H




/*
 *	Open file
 *
 */
extern	FILE *open_file(char *filename, char *openmode);




/*
 *	If pointed char is a comment one return true
 *	comment chars are:   ;  *  #
 *
 */
extern	int is_comment_char(char *string);




/*
 *	Skip all space or tab chars of src
 *
 */
extern	char *skip_spaces(char *src);




#ifdef __DEBUG
/*
 *	Skip all non space or tab chars of src
 *
 */
extern	char *skip_non_spaces(char *src);
#endif




/*
 *	strip ending LF from src and return ptr to beginning of src
 *
 */
extern	char *strip_lf(char *src);




/*
 *	print the format error message associated to "format_error"
 *
 */
extern	void print_format_error_msg(char *filename, char *format_error_line, int format_error);



#endif
