#ifndef _OPT_FUNC_H
#define _OPT_FUNC_H

/* File   : opt_func.h                                                      */
/* Purpose: Definitions and include files needed by opt_func.c.             */

#include <stdio.h>  /* FILE * */


/* Header flag definitions */
#define CHECKCASE 0x01
#define NO_TYPE   0x02

/* Node flag definitions */
#define NO_PRINT 0x01

/* Node type flag definitions */
#define NO_T     0
#define RUN_T    1
#define MENU_T   2
#define FILE_T   3
#define EXIT_T   4


/* Data Type Definitions */
struct option_node_t {
  char *name;
  char *value;
  char *comment;
  char *file;
  int type;
  int flag;
  struct option_node_t *next;
};  typedef struct option_node_t *option_node;

struct option_head_t {
  char *opttail;
  char *prompt;
  int flag;
  int size;
  int type;
  option_node list;
};  typedef struct option_head_t *option_head;


/* Function Prototypes */
int listsize(option_node);
int plistsize(option_node);
int testopt(option_node);

option_head addoption(option_head, option_node);
option_head clearlist(option_head);
option_head newlist(void);

option_node clearnode(option_node);
option_node newnode(void);
option_node read_option(FILE *);
option_node scanvalue(option_head, char *);

#endif  /* OPT_FUNC_H */
