#ifndef _MENU_FUNC_H
#define _MENU_FUNC_H

/* File   : menu_func.h                                                     */
/* Purpose: Definitions and include files needed by menu_func.c.            */

#include <stdio.h>

/* Flag Values */
#define COMMENTS 0x01
#define SPACE    0x02
#define TO_EOL   0x04
#define WHITE    0x08

/* Global Variables */
int line;

/* Function Prototypes */
char *get_arguments(FILE *);
char *get_name(char *);
char *get_option(FILE *);
char *lowercase(char *);
char *itoa(int);
char *stripdots(char *);

int getcols(void);

void center(char *);
void clearscr(void);
void error(char *, char *, int);
void parseenv(char *);
void printhead(char *, char *);
void printfile(char *, int);
void printline(int);
void printlineof(int, char *);
void printstr(char *);
void reverse(char *);
void runprog(char *, int);
void skip (FILE *, int);
void skip_line(FILE *, int);
void waitkey(void);

#endif  /* _MENU_FUNC_H */
