#!/bin/sh

# Program: install.sh
# Author : Karyl F. Stein <xenon@xenos.net>
# Purpose: Easy configuration and installation program for xenmenu.


########## Defaults ##########################################################
BASEDIR="/usr/local/xenmenu-0.8a"
SECURITY=0
SUPPORTDIR="bin"
MENUDIR="menus"
VIEWDIR="text"
SECUREPATH="/bin:/usr/bin:/usr/local/bin"


########## Introduction ######################################################
cat << EOF

Welcome to xenmenu!

This script will compile and install xenmenu on your system.  You will first
be asked a series of questions which will be explained below.  Then, xenmenu
and all of the optional support files that you choose will be installed on
your system.  If you would rather install xenmenu by hand, please read the
"Detailed Install" instructions in the README file.

Unless you are installing xenmenu in your home directory, or in a directory to
which you have write permissions, you should probably run this script as root.

EOF

echo "Press ENTER to Continue"
read junk

cat << EOF

------------------------------------------------------------------------------

Each question has a default value which is enclosed in brackets ([]) after
the question.  To choose the default value given, just press ENTER.  If a
yes or no question is asked, you should enter y for yes or n for no.  If you
do not exactly respond with y for yes, then no is assumed.  For example, if
the question is

Compile Optional Modules (enter y for yes) [n]

then you would just press enter for no, otherwise you should enter y.  As
another example, if the question reads

Enter base directory [$BASEDIR]

then you should either enter an alternate base directory, or just press ENTER
to accept the default of $BASEDIR.

EOF

echo "Press ENTER to Continue"
read junk

cat << EOF

------------------------------------------------------------------------------

You will now be asked if you want to continue with the installation process.
Remember, you must enter y for yes if you want to continue!

EOF

echo "Continue with the installation of xenmenu [n]"
read junk

if [ "X$junk" != "Xy" -a "X$junk" != "XY" -a "X$junk" != "Xyes" -a "X$junk" != "XYES" ]; then
    echo $junk
    echo "Installation aborted!"
    echo
    exit
fi


########## Base install directory ############################################
cat << EOF

------------------------------------------------------------------------------

Please enter the base directory under which you want xenmenu installed.  The
main xenmenu program will be installed in the bin directory under this
directory.

For example, if you choose /usr/local as your base directory, then xenmenu will
be placed in /usr/local/bin/xenmenu.

EOF

echo "Base directory [$BASEDIR]"
read MYBASEDIR
if [ ! -z "$MYBASEDIR" ]; then
    BASEDIR="$MYBASEDIR"
fi


########## Security setting ###################################################
cat << EOF

------------------------------------------------------------------------------

You will now be asked for a security setting for xenmenu.  The levels of
security are as follows:

  0 - No security checks are made
  1 - Only programs in a certain directory can be run from the menu
  2 - Only menu files in a certain directory can be loaded
  4 - Only files in a certain directory can be viewed

To choose your level of security, add the above option values.  For example, a
SECURE setting of 6 (4 + 2) means that menus and files can only be loaded and
viewed from their respective directories.

If you choose a secure setting other than 0, you will be asked for directory
information in a moment.

Please see the Securing xenmenu section of the README for more information.

EOF

MYSECURITY=""
while [ "$MYSECURITY" != "0" -a "$MYSECURITY" != "1" -a "$MYSECURITY" != "2" -a "$MYSECURITY" != "3" -a "$MYSECURITY" != "4" -a "$MYSECURITY" != "5" -a "$MYSECURITY" != "6" -a "$MYSECURITY" != "7" ]; do
    if [ ! -z $MYSECURITY ]; then
	echo
	echo "Invalid security setting!  Must be a number between and including 0 and 7."
	echo
    fi
    echo "Security setting [$SECURITY]"
    read MYSECURITY
    if [ -z "$MYSECURITY" ]; then
	MYSECURITY="$SECURITY"
    fi
done
SECURITY="$MYSECURITY"


########## Menu directory #####################################################
cat << EOF

------------------------------------------------------------------------------

Please enter the default directory under which the system menus will be
installed.  When xenmenu is run, it will first search this directory for menu
files.

EOF

if [ $SECURITY = 2 -o $SECURITY = 3 -o $SECURITY = 6 -o $SECURITY = 7 ]; then
    echo "Due to your security setting, only menus in this directory may be loaded."
else
    echo "If this directory does not exist, a full path to the menu to load must be"
    echo "given when you run xenmenu."
fi

echo
echo "Menu directory [$BASEDIR/$MENUDIR]"
read MYMENUDIR
if [ ! -z "$MYMENUDIR" ]; then
    MENUDIR="$MYMENUDIR"
else
    MENUDIR="$BASEDIR/$MENUDIR"
fi


########## Run directory #####################################################
cat << EOF

------------------------------------------------------------------------------

Please enter the default path for support programs.  The path is a colon
seperated list of directories that xenmenu will search when it is asked to
execute a program.  For example, /bin:/usr/bin:/usr/local/bin is a valid
setting.

EOF

if [ $SECURITY = 1 -o $SECURITY = 3 -o $SECURITY = 5 -o $SECURITY = 7 ]; then
    echo "Due to your security setting, only programs in these directories may be"
    echo "executed.  If you specify a path to the program in the menu, it will be"
    echo "ignored."
    echo
    echo "Support path [$BASEDIR/$SUPPORTDIR]"
else
    echo "Even if this is defined, the user's \$PATH environment variable will be"
    echo "searched.  You may also define a full pathname for the program, (which is"
    echo "suggested)."
    echo
    echo "Support path [$SECUREPATH]"
fi

read MYSESUREPATH
if [ ! -z "$MYSECUREPATH" ]; then
    SECUREPATH="$MYSECUREPATH"
else
    if [ $SECURITY = 1 -o $SECURITY = 3 -o $SECURITY = 5 -o $SECURITY = 7 ]
    then
	SECUREPATH="$BASEDIR/$SUPPORTDIR"
    fi
fi


########## View directory ####################################################
if [ $SECURITY = 4 -o $SECURITY = 6 -o $SECURITY = 7 ]; then
    echo "------------------------------------------------------------------------------"
    echo
    echo "You have defined that only files in a certain directory may be viewed from"
    echo "menus.  You will now be asked to define that directory."
    echo
    echo "View directory [$BASEDIR/$VIEWDIR]"
    read MYVIEWDIR
    if [ ! -z "$MYVIEWDIR" ]; then
	VIEWDIR="$MYVIEWDIR"
    fi
fi


########## Support programs ##################################################
cat <<EOF

------------------------------------------------------------------------------

Xenmenu comes with some support programs that you may find useful in your
menus.  There are shell front-ends for many common and not-so-common *NIX
utilities, (e.g. ftp, telnet, and ssh), and some programs for handling tasks
such as showing and setting of the backspace key.  For more information about
these programs, please see the contrib/README file.  You may need to configure
these programs by hand before using!

EOF

echo "Would you like the support programs installed [n]"
read junk
if [ "X$junk" != "Xy" -a "X$junk" != "XY" -a "X$junk" != "Xyes" -a "X$junk" != "XYES" ]; then
    SUPPORT=n
else
    SUPPORT=y
fi

if [ $SUPPORT = y ]; then
    echo
    echo "Please enter the directory under which you want the support programs"
    echo "installed."
    echo
    echo "Support directory [$BASEDIR/$SUPPORTDIR]"
    read MYSUPPORTDIR
    if [ ! -z "$MYSUPPORTDIR" ]; then
	SUPPORTDIR="$MYSUPPORTDIR"
    else
	SUPPORTDIR="$BASEDIR/$SUPPORTDIR"
    fi
fi

########## Sample menus ######################################################
cat << EOF

------------------------------------------------------------------------------

Xenmenu comes with some sample menu files that you may find useful when
designing your own menus.  You may view these menus by looking in the
sample_menus directory, or you may install them.  If you install them, they
will be placed in $MENUDIR.

EOF

echo "Would you like the sample menus installed [n]"
read junk
if [ "X$junk" != "Xy" -a "X$junk" != "XY" -a "X$junk" != "Xyes" -a "X$junk" != "XYES" ]; then
    SAMPLE_MENUS=n
else
    SAMPLE_MENUS=y
fi


########## Sample text files #################################################
cat << EOF

------------------------------------------------------------------------------

Xenmenu comes with some sample text files that you may find useful when
designing your own menus.  You may view these files by looking in the
sample_text directory, or you may install them.

EOF

echo "Would you like the sample text files installed [n]"
read junk
if [ "X$junk" != "Xy" -a "X$junk" != "XY" -a "X$junk" != "Xyes" -a "X$junk" != "XYES" ]; then
    SAMPLE_TEXT=n
else
    SAMPLE_TEXT=y
fi

if [ -z "$MYVIEWDIR" -a $SAMPLE_TEXT = "y" ]; then
    echo
    echo "Please enter the base directory under which you want the sample text files"
    echo "installed."
    echo
    echo "Text base directory [$BASEDIR/$VIEWDIR]"
    read MYVIEWDIR
    if [ ! -z "$MYVIEWDIR" ]; then
	VIEWDIR="$MYVIEWDIR"
    else
	VIEWDIR="$BASEDIR/$VIEWDIR"
    fi
fi


########## Make sure everything is right #####################################
cat << EOF

------------------------------------------------------------------------------

You have made it to the end of the configuration section.  Please check the
following answers for correctness.

EOF

echo "Install xenmenu in      : $BASEDIR/bin"
echo "Security setting        : $SECURITY"
echo "Menu Directory          : $MENUDIR"
echo "Support Path            : $SUPPORTDIR"
if [ $SECURITY = 4 -o $SECURITY = 6 -o $SECURITY = 7 ]; then
    echo "View Directory          : $VIEWDIR"
fi
if [ $SECURITY = 1 -o $SECURITY = 3 -o $SECURITY = 5 -o $SECURITY = 7 ]; then
    echo "Secure Path             : $SECUREPATH"
fi
if [ $SUPPORT = "y" ]; then
    echo "Install Support Programs: Yes - $SUPPORTDIR"
else
    echo "Install Support Programs: No"
fi
if [ $SAMPLE_MENUS = "y" ]; then
    echo "Install Sample Menus    : Yes - $MENUDIR"
else
    echo "Install Sample Menus    : No"
fi
if [ $SAMPLE_TEXT = "y" ]; then
    echo "Install Sample Text     : Yes - $VIEWDIR"
else
    echo "Install Sample Text     : No"
fi

echo
echo "Continue with the installation of xenmenu [n]"
read junk

if [ "X$junk" != "Xy" -a "X$junk" != "XY" -a "X$junk" != "Xyes" -a "X$junk" != "XYES" ]; then
    echo
    echo "Installation aborted!"
    echo
    exit
fi

########## Configure, compile, and install ###################################
echo
echo "Configuring xenmenu"
echo
./configure --prefix="$BASEDIR" --with-security="$SECURITY" --with-menu-dir="$MENUDIR" --with-support-dir="$SUPPORTDIR" --with-view-dir="$VIEWDIR" --with-path="$SECUREPATH"

echo
echo "Compiling xenmenu"
echo
make

if [ $SUPPORT = "y" ]; then
    echo
    echo "Compiling support programs"
    echo
    (cd contrib; make)
fi

echo
echo "Installing xenmenu..."
echo
make install

if [ $SUPPORT = "y" ]; then
    echo
    echo "Installing support programs..."
    echo
    (cd contrib; make install; make install_scripts)
fi

if [ $SAMPLE_MENUS = "y" ]; then
    echo
    echo "Installing sample menus..."
    echo
    cp -R sample_menus/* $MENUDIR
    chmod 644 $MENUDIR/*
    chmod 755 $MENUDIR/*menus
    chmod 644 $MENUDIR/menus/*/*
fi

if [ $SAMPLE_TEXT = "y" ]; then
    echo
    echo "Installing sample text files..."
    echo
    cp sample_text/* $VIEWDIR
    chmod 644 $VIEWFIR/*
fi

echo
echo "Done!  Type $BASEDIR/bin/xenmenu to try it out."
