#ifndef _GET_INPUT_H
#define _GET_INPUT_H

/* File   : get_input.h                                                      */
/* Purpose: Definitions for get_input.c.                                     */

/* The character to send to the user when they enter invalid input.  The     */
/* default is 007 (ASCII bell character).                                    */
#define ERROR     007

/* This is the character used for help requests.  The default is ?.          */
#define HELPCHAR  '?'

/* This is the character that is displayed when the NOSHOW flag is set.      */
/* The default is *.                                                         */
#define NOSHOWCHAR '*'


/*********** DO NOT CHANGE anything below this line unless you know what     */
/*********** you are doing.                                                  */


/* Flag definitions (no need to change and it might be bad if you do).       */
#define LETTER    1
#define NUMBER    2
#define TEXT      4
#define LOWERCASE 8
#define ANY       16
#define FIELD     32
#define HELP      64
#define NOSHOW    128

/* Function prototypes */
char *get_input(char *, int, int, int);

#endif  /* _GET_INPUT_H */
