/* File     : dochoice.c
 * Author   : Karyl F. Stein <steinkf@cs.purdue.edu>
 * Purpose  : Functions for use with the xenmenu program.  Descriptions of the
 *            individual functions are given before the function.
 *
 * Xenmenu is Copyright (C)1996 Karyl F. Stein
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include "xenmenu.h"
#include "opt_func.h"
#include "menu_func.h"
#include "dochoice.h"


/* Function: dochoice
 * Input   : Option list and string input
 * Output  : Execute the choice, or, if the choice is not found, try to
 *           run the choice as a program.
 */
char *dochoice (option_head options, char *choice) {
  option_node ptr;

  if ((ptr = scanvalue(options, choice)) != NULL) {
    switch (ptr->type) {
    case FILE_T:
      printfile(ptr->file, TRUE);
      break;
    case MENU_T:
      return(ptr->file);
    case RUN_T:
      runprog(ptr->file, TRUE);
      break;
    case EXIT_T:
      exit(0);
    default:
      error("Invalid option type", NULL, 0);
      break;
    }
  } else runprog(choice, TRUE);

  return(NULL);
}
