/* File     : show_backspace.c
 * Author   : Karyl F. Stein
 * Purpose  : Display the backspace key.
 *
 * Copyright: (c)1997 Karyl F. Stein <steinkf@cs.purdue.edu>
 *
 *            Permission is granted to use this code in whole or in part for
 *            non-commercial purposes as long as the following conditions are
 *            met:
 *
 *            1) Any modifications to this code are clearly marked if the
 *               modified code is distributed to other people other than the
 *               modifier,
 *            2) This copyright remains with any distributed versions, and
 *            3) Credit is given to the author if parts of this code are used.
 *
 *            If you use this code to make money in any form or if you use
 *            this code on a commercial system, you must obtain a license from
 *            the holder of this copyright.  To obtain a license, mail the
 *            copyright holder listed at the top of this copyright notice.
 *
 * USE THIS PROGRAM AT YOUR OWN RISK.  This program is provided as-is without
 * any warranty of any kind, either expressed or implied, including, but not
 * limited to, the implied warranties of merchantability and fitness for a
 * particular purpose.  The entire risk as to the quality and performance of
 * this program is with you.  Should this program prove defective, you assume
 * the cost of all necessary servicing, repair, or correction.
 */

#include <termios.h>            /* Terminal manipulation */
#include <unistd.h>             /* Terminal manipulation */
#include <stdio.h>

main(int argc, char *argv[]) {
  struct termios curr_scr;

  if (tcgetattr(0, &curr_scr) == -1) {
    fprintf(stderr, "Unable to get terminal settings\n");
    exit(1);
  }

  if (curr_scr.c_cc[VERASE] < 0x20) {
    curr_scr.c_cc[VERASE] |= 0x40;
    printf("CONTROL-%c (^%c)", curr_scr.c_cc[VERASE], curr_scr.c_cc[VERASE]);
  } else if (curr_scr.c_cc[VERASE] == 0x7f) {
      printf("Delete (^?)");
  } else printf("%c", curr_scr.c_cc[VERASE]);
}
