/*
 * View.h - header file for class View
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * View is an abstract class that defines the interface for its subclasses.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef VIEW_H
#define VIEW_H

#include "ModelViewSpeaker.h"

class View
{
 public:
  virtual void setModel(Model* m)=0;
  virtual void updateView()=0;
  virtual void handleEvents()=0;
  virtual void display(char* msg1, char* msg2, bool isMsg, double pause)=0;
  virtual bool getRecOn()=0;
  virtual void setRecOn(bool on)=0;
  virtual void speakWav(char* wav)=0;
 protected:
  Model* model;
  Speaker* speaker;
};

#endif
