/*
 * StdModem.h - header file for class StdModem
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * StdModem is an implementation of class Modem.  It should be 
 * applicable for any standard modem type.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef STDMODEM_H
#define STDMODEM_H

#include "Modem.h"
#include <termios.h>

class StdModem: public Modem
{
 public:
  virtual bool openPort();
  virtual void closePort();
  virtual void readLine(char* buffer);
  virtual int getDes();
 private:
  void writeLine(char* buffer);
  termios newtio;
  termios oldtio;
  int fd;
};

#endif
