/*
 * RegionUSA.C - source file for class RegionUSA
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "RegionUSA.h"

#include <string.h>

const char* NAME_PRE = "NAME = ";
const char* NMBR_PRE = "NMBR = ";
const char* RING = "RING";
const int MAX = 32;

bool RegionUSA::isAllFields(char* data)
{
  return false;
}


bool RegionUSA::isNameField(char* data)
{
  return strstr(data, NAME_PRE);
}


bool RegionUSA::isNmbrField(char* data)
{
  return strstr(data, NMBR_PRE);
}

bool RegionUSA::isRing(char* data)
{
  return strstr(data, RING);
}


void RegionUSA::getName(char* data, char* name)
{
  for(unsigned int i=0; i<(strlen(data)-strlen(NAME_PRE)); i++) {
    name[i] = data[i+strlen(NAME_PRE)];
  }
  name[strlen(data)-strlen(NAME_PRE)]=0;
}


void RegionUSA::getNmbr(char* data, char* nmbr)
{
  if(data[strlen(NMBR_PRE)] == 'O') {
    strcpy(nmbr, "Out of Area");
  }
  else if(data[strlen(NMBR_PRE)] == 'P') {
    strcpy(nmbr, "Private");
  }
  else {
    for(unsigned int i=0; i<3; i++) {
      nmbr[i] = data[i+strlen(NMBR_PRE)];
    }
    nmbr[3]='-';
    for(unsigned int i=0; i<3; i++) {
      nmbr[4+i] = data[3+i+strlen(NMBR_PRE)];
    }
    nmbr[7]='-';
    for(unsigned int i=0; i<4; i++) {
      nmbr[8+i] = data[6+i+strlen(NMBR_PRE)];
    }
    nmbr[strlen(data)-strlen(NMBR_PRE)+2]=0;
  }
}


