/*
 * RegionIsdn.C - source file for class RegionIsdn
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "RegionIsdn.h"

#include <string.h>

const char* NAME_PRE = "NAME = ";
const char* NMBR_PRE = "NMBR = ";
const char* RING = "RING";
const int MAX = 255;

bool RegionIsdn::isAllFields(char* data)
{
  return strstr(data, "isdn_tty: call from");
}


bool RegionIsdn::isNameField(char* data)
{
  return false;
}


bool RegionIsdn::isNmbrField(char* data)
{
  return false;
}

bool RegionIsdn::isRing(char* data)
{
  return false;
}


void RegionIsdn::getName(char* data, char* name)
{
  strcpy(name, "Unknown");
}


void RegionIsdn::getNmbr(char* data, char* nmbr)
{
  char temp[255];
  strcpy(temp, data);
  
  strcpy(nmbr, strtok(temp, " "));

  while(strcmp(nmbr, "isdn_tty:")) {
    strcpy(nmbr, strtok(NULL, " "));
  }

  while(strcmp(nmbr, "call")) {
    strcpy(nmbr, strtok(NULL, " "));
  }

  while(strcmp(nmbr, "from")) {
    strcpy(nmbr, strtok(NULL, " "));
  }

  strcpy(nmbr, strtok(NULL, " "));
  
}
