/*
 * PgsqlDbase.h - header file for class PgsqlDbase
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 * Copyright (c) 1999 George B. Smith <brannonsmith@yahoo.com>
 *
 * This class implements the abstract class Dbase, using PostgreSQL.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef PGSQLDBASE_H
#define PGSQLDBASE_H

#include "Dbase.h"
#include "libpq-fe.h"

#define NUMFIELDS 5

class PgsqlDbase : public Dbase
{
public:
   bool openDbase();
   bool lookupEntry(char* field, char* value);
   char** getRow();
   bool moreRow();
   void addEntry(char* name, char* nmbr, char* greet);
   virtual void getDate(time_t t, char* buffer);
   virtual void updateDbase(char* key1, char* val1, char* key2, char* val2);

private:
   void getTime(time_t t, char* buffer);

   /* Hacks to iterate through PGresult */
   char** fetchRow();
   void storeResult();

   /* data for iteration */
   int currentRow;
   int rowsLeft;
   char* row[NUMFIELDS];

   PGconn *sock;
   int numRows;
   PGresult* queryRet;
};

#endif


