/*
 * PgsqlDbase.C - source file for class PgsqlDbase
 * Copyright (c) 1999 George B. Smith <brannonsmith@yahoo.com>
 * based on
 * MysqlDbase.C & MsqlDbase.C
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "PgsqlDbase.h"

#include <stdio.h>
#include <time.h>

char* dbase = "xcallerid";
char* create = "CREATE TABLE calls ( number char(15) not null, name text, call_date date, call_time time, incoming char(50) )";

/*----------------------------------------------------------------------*/
bool PgsqlDbase::openDbase()
{
   sock=PQsetdb(NULL, NULL, NULL, NULL, dbase);
   if(PQstatus(sock) == CONNECTION_BAD)
      return false;

   queryRet = PQexec(sock, create);
   storeResult();
   return true;
}

/*----------------------------------------------------------------------*/
bool PgsqlDbase::lookupEntry(char* field, char* value)
{
   char command[256];
   sprintf(command,
	   "SELECT number, name, call_date, call_time, incoming FROM calls WHERE %s = '%s'",
	   field, value);
   PQclear(queryRet);
   queryRet = PQexec(sock, command);
   if(PQresultStatus(queryRet) == PGRES_TUPLES_OK)
   {
      storeResult();
      numRows = PQntuples(queryRet);
   }
   else
      numRows=0;
   return moreRow();
}

/*----------------------------------------------------------------------*/
char** PgsqlDbase::getRow()
{
   numRows--;
   return fetchRow();
}

/*----------------------------------------------------------------------*/
bool PgsqlDbase::moreRow()
{
   return (numRows > 0);
}

/*----------------------------------------------------------------------*
 * These two functions are hacks for for PostgreSQL whose C access library
 * libpq doesn't seem to have functions to fetch a row... weird.
 * I couldn't tell if the MySQL version does a deep copy (w/strcpy)
 * but upon examining xcallerid code, I figured a ptr copy is enough
 *----------------------------------------------------------------------*/
void PgsqlDbase::storeResult() // no args - queryRet assumed
{
   currentRow = 0;
   if(queryRet == NULL)
   {
      rowsLeft = 0;
      return;
   }

   if(PQresultStatus(queryRet) == PGRES_TUPLES_OK)
      rowsLeft = PQntuples(queryRet); // separate from numRows...
   else
      rowsLeft = 0;
}

/*----------------------------------------------------------------------*/
char**  PgsqlDbase::fetchRow() // no args - queryRet assumed
{
   int numFields;

   if(rowsLeft <= 0) return NULL;

   /* Assume numFields matches NUMFIELDS declared in .h */
   numFields = PQnfields(queryRet);
   for(int i = 0; i < numFields; i++)
   {
      // Copy ptrs to tuple fields in result
      row[i] = PQgetvalue(queryRet, currentRow, i);
   }

   rowsLeft--;
   currentRow++; // move forward in result set

   return row;
}

/*----------------------------------------------------------------------*/
void PgsqlDbase::addEntry(char* name, char* nmbr, char* greet)
{
   time_t time_now = time(NULL);
   char command[256];
   char thisDate[64], thisTime[64];

   getDate(time_now,thisDate);
   getTime(time_now,thisTime);

   sprintf(command, "INSERT INTO calls ( number, name, call_date, call_time, incoming ) VALUES ( '%s', '%s', '%s', '%s', '%s' )",
           nmbr, name, thisDate, thisTime, greet);
   PQexec(sock, command);
   storeResult();
}

/*----------------------------------------------------------------------*/
void PgsqlDbase::getDate(time_t t, char* buffer)
{
   char* temp = ctime((const time_t*)(&t));
   for(int i=0;i<2;i++) {
      buffer[i]=temp[i+8];
   }
   buffer[2]='-';
   for(int i=0;i<3;i++) {
      buffer[3+i]=temp[i+4];
   }
   buffer[6]='-';
   for(int i=0;i<4;i++) {
      buffer[7+i]=temp[i+20];
   }
   buffer[11]=0;
   //printf("date=%s\n", buffer);
   //sprintf(buffer, "%1s%1s-%1s%1s%1s-%1s%1s%1s%1s",
   //        &temp[8],&temp[9],temp+4,temp+5,temp+6,
   //        temp+20,temp+21,temp+22,temp+23);
}

/*----------------------------------------------------------------------*/
void PgsqlDbase::getTime(time_t t, char* buffer)
{
   char* temp = ctime((const time_t*)(&t));
   for(int i=0;i<8;i++) {
      buffer[i]=temp[i+11];
   }
   buffer[8]=0;
   //printf("time=%s\n", buffer);
   //sprintf(buffer, "%1s%1s:%1s%1s:%1s%1s",
   //        temp+11,temp+12,temp+14,temp+15,temp+17,temp+18);
}

/*----------------------------------------------------------------------*/
void PgsqlDbase::updateDbase(char* key1, char* val1, char* key2, char* val2)
{
   char ucommand[256];
   sprintf(ucommand, "UPDATE calls SET %s = '%s' WHERE %s = '%s'",
	   key1, val1, key2, val2);

   queryRet = PQexec(sock,ucommand);
   storeResult();
}

