/*
 * MysqlDbase.C - source file for class MysqlDbase
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "MysqlDbase.h"

#include <stdio.h>
#include <time.h>

char* dbase = "xcallerid";
char* create = "CREATE TABLE calls ( number text, name text, call_date text, call_time time, incoming text )";


bool MysqlDbase::openDbase()
{
  if((sock=mysql_connect(NULL, "localhost", "root", NULL)) == NULL) {
    return false;
  }  
  
  mysql_create_db(sock, dbase);

  if(mysql_select_db(sock,dbase) != 0) {
    return false;
  }
  mysql_query(sock,create);
  queryRet = mysql_store_result(sock);
  return true;
}


bool MysqlDbase::lookupEntry(char* field, char* value)
{
  char command[256];
  sprintf(command, 
	  "SELECT number, name, call_date, call_time, incoming FROM calls WHERE %s = '%s'",
	  field, value);
  mysql_free_result(queryRet);
  mysql_query(sock, command);
  if((queryRet = mysql_store_result(sock)) != NULL)
    numRows = mysql_num_rows(queryRet);
  else
    numRows=0;
  return moreRow();
}


char** MysqlDbase::getRow()
{
  numRows--;
  MYSQL_ROW row = mysql_fetch_row(queryRet);
  return (char**)(row);
}


bool MysqlDbase::moreRow()
{
  return (numRows > 0);
}

void MysqlDbase::addEntry(char* name, char* nmbr, char* greet)
{
  time_t time_now = time(NULL);
  char command[256];
  char thisDate[64], thisTime[64];

  getDate(time_now,thisDate);
  getTime(time_now,thisTime);

  sprintf(command, "INSERT INTO calls ( number, name, call_date, call_time, incoming ) VALUES ( '%s', '%s', '%s', '%s', '%s' )", nmbr, name, thisDate, thisTime, greet);
  mysql_query(sock, command);
  queryRet = mysql_store_result(sock); 
}

void MysqlDbase::getDate(time_t t, char* buffer)
{
  char* temp = ctime((const time_t*)(&t));
  for(int i=0;i<2;i++) {
    buffer[i]=temp[i+8];
  }
  buffer[2]='-';
  for(int i=0;i<3;i++) {
    buffer[3+i]=temp[i+4];
  }
  buffer[6]='-';
  for(int i=0;i<4;i++) {
    buffer[7+i]=temp[i+20];
  }
  buffer[11]=0;
  //printf("date=%s\n", buffer);
  //sprintf(buffer, "%1s%1s-%1s%1s%1s-%1s%1s%1s%1s", &temp[8],&temp[9],temp+4,temp+5,temp+6,temp+20,temp+21,temp+22,temp+23);
}

void MysqlDbase::getTime(time_t t, char* buffer)
{  
  char* temp = ctime((const time_t*)(&t));
  for(int i=0;i<8;i++) {
    buffer[i]=temp[i+11];
  }
  buffer[8]=0;
  //printf("time=%s\n", buffer);
  //sprintf(buffer, "%1s%1s:%1s%1s:%1s%1s", temp+11,temp+12,temp+14,temp+15,temp+17,temp+18);
}

void MysqlDbase::updateDbase(char* key1, char* val1, char* key2, char* val2)
{
  char ucommand[256];
  sprintf(ucommand, "UPDATE calls SET %s = '%s' WHERE %s = '%s'", key1, val1, key2, val2);
  mysql_query(sock,ucommand);
  queryRet = mysql_store_result(sock);
}
