/*
 * MsqlDbase.C - source file for class MsqlDbase
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "MsqlDbase.h"

#include <stdio.h>
#include <time.h>

char* dbase = "xcallerid";
char* create = "CREATE TABLE calls ( number char(15) not null, name text(20), call_date date, call_time time, incoming char(50) )";


bool MsqlDbase::openDbase()
{
  if((sock=msqlConnect(NULL)) == -1) {
    return false;
  }  
  if(msqlSelectDB(sock,dbase) == -1) {
    return false;
  }
  msqlQuery(sock,create);
  return true;
}


bool MsqlDbase::lookupEntry(char* field, char* value)
{
  char command[256];
  sprintf(command, 
	  "SELECT number, name, call_date, call_time, incoming FROM calls WHERE %s = '%s'",
	  field, value);
  numRows = msqlQuery(sock, command);

  queryRet = msqlStoreResult();
  return moreRow();
}


char** MsqlDbase::getRow()
{
  numRows--;
  m_row row = msqlFetchRow(queryRet);
  return (char**)(row);
}


bool MsqlDbase::moreRow()
{
  return (numRows > 0);
}

void MsqlDbase::addEntry(char* name, char* nmbr, char* greet)
{
  time_t time_now = time(NULL);
  char command[256];

  sprintf(command, "INSERT INTO calls ( number, name, call_date, call_time, incoming ) VALUES ( '%s', '%s', '%s', '%s', '%s' )", nmbr, name, msqlUnixTimeToDate(time_now), msqlUnixTimeToTime(time_now), greet);
  msqlQuery(sock, command);
 
}

void MsqlDbase::getDate(time_t t, char* buffer)
{
  strcpy(buffer, msqlUnixTimeToDate(t));
}

void MsqlDbase::updateDbase(char* key1, char* val1, char* key2, char* val2)
{
  char ucommand[256];
  sprintf(ucommand, "UPDATE calls SET %s = '%s' WHERE %s = '%s'", key1, val1, key2, val2);
  msqlQuery(sock,ucommand);
}
