/*
 * Modem.h - header file for class Modem
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * Modem is an abstract class that declares the interface which is
 * implemented by the Modem subclasses.  It is not entirely implementation
 * independent, since it is necessary to have a file descriptor of some
 * sort associated with the Modem.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef MODEM_H
#define MODEM_H

class Modem
{
 public:
  virtual bool openPort()=0;  
  virtual void closePort()=0;
  virtual void readLine(char* buffer)=0;
  virtual int getDes()=0;
};

#endif
