/*
 * Model.h - header file for class Model
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * Class Model is an abstract class that declares the functions
 * needed by an implementation of a Model, and what data members it
 * should have.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef MODEL_H
#define MODEL_H

#include "Dbase.h"
#include "ModelViewSpeaker.h"
#include "Modem.h"
#include "Region.h"

class Model
{
 public:
  virtual void runModel()=0;
  virtual void quitModel()=0;
  virtual Dbase* getDbase()=0;
  virtual void setView(View* v)=0;
  virtual void startModel()=0;
  virtual void stopModel()=0;
 protected:
  Dbase* dbase;
  View* view;
  Modem* modem;
  Region* region;
};

#endif
