/*
 * IsdnModem.C - source file for class IsdnModem
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "IsdnModem.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>

const int MAX=255;
const int BAUDRATE=38400;

//const char* LOGFILE = "/var/log/messages";
//const char* LOGFILE = "messages";

bool IsdnModem::openPort()
{
  if( (fd = open(MODEM, O_RDONLY)) == -1 ) {
    return false;
  }
  lseek(fd,0,SEEK_END);
  return true;
}

void IsdnModem::closePort()
{
  close(fd);
  fd = -1;
}

void IsdnModem::readLine(char* buffer)
{
  int i=0;
  int j;
  char temp[1];
  j=read(fd,temp,1);
  while(j > 0 && temp[0] != '\n' && temp[0] != '\r' && i < MAX) {
    buffer[i++]=temp[0];
    j=read(fd,temp,1);
  }
  buffer[i]=0;
}

void IsdnModem::writeLine(int fd, char* buffer)
{
}

int IsdnModem::getDes()
{
  return fd;
}

