/*
 * GtkView.h - header file for class GtkView
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * GtkView provides an implementation of the abstract class View, using
 * Gtk_Window as one of its base classes.  It uses the Gtk-- event handling
 * model (the connect_to_* functions)..
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef GTKVIEW_H
#define GTKVIEW_H

#include "View.h"
#include <gtk--.h>

class GtkView : public Gtk_Window, public View
{
 public:
    GtkView(Model* m);
    virtual void setModel(Model* m);
    virtual void updateView();
    virtual void handleEvents();
    virtual void display(char* msg1, char* msg2, bool isMsg, double pause);
    virtual bool getRecOn();
    virtual void setRecOn(bool on);
    virtual void speakWav(char* wav);
    gint delete_event_impl(GdkEventAny *);
 private:
    
    void destroy();
    
    void killWidget(Gtk_Widget* data);
    int killWidgetCallback(Gtk_Widget* data);
    
    
    void displayAbout();
    
    void editNameCallback();
    void editGreetCallback();
    void editPlayCallback();
    void editRecordCallback();
    
    void fileCallback(string item);
    void editCallback(string item);
    void searchCallback(string item);
    void daemonCallback(string item);
    void helpCallback(string item);
    
/*
  void searchDateCallback();
  void searchNameCallback();
  void searchNumbCallback();
*/
    void selectionMade(gint row, gint column, GdkEvent* button);
    void selectionLost(gint row, gint column, GdkEvent* button);
    
    void updateNameCallback(Gtk_Entry* data);
    void updateGreetCallback(Gtk_FileSelection* data);
    
    void searchDateUpdate(Gtk_Entry* data);
    void searchNameUpdate(Gtk_Entry* data);
    void searchNumbUpdate(Gtk_Entry* data);
    
    void recWav(Gtk_FileSelection* data);
    void stopRecCallback();
    
    void resetList();  
    
    Gtk_ItemFactory* itemFactory;
    Gtk_AccelGroup* accelGroup;
    
    Gtk_MenuBar* menuBar;
    
    Gtk_Menu* fileMenu;
    Gtk_Menu* editMenu;
    Gtk_Menu* searchMenu;
    Gtk_Menu* daemonMenu;
    Gtk_Menu* helpMenu;
    
    
    Gtk_MenuItem* fileItem;
    Gtk_MenuItem* editItem;
    Gtk_MenuItem* searchItem;
    Gtk_MenuItem* daemonItem;
    Gtk_MenuItem* helpItem;
    
    
    Gtk_MenuItem* fileExitItem;
    Gtk_MenuItem* editNameItem;
    Gtk_MenuItem* editGreetItem;
    Gtk_MenuItem* editPlayItem;
    Gtk_MenuItem* editRecItem;
    Gtk_MenuItem* searchDateItem;
    Gtk_MenuItem* searchNumbItem;
    Gtk_MenuItem* searchNameItem;
    Gtk_MenuItem* daemonStartItem;
    Gtk_MenuItem* daemonStopItem;
    Gtk_MenuItem* helpAboutItem;
    
    Gtk_VBox* vbox;
    
    
    Gtk_ScrolledWindow* callListWin;
    
    Gtk_CList* callList;
    
    char oldField[256];
    char oldValue[256];
/*
  int ncalls;
*/
    bool recOn;
    int rowSelect;
    
    int numRows;
};

#endif
