/*
 * GtkView.C - source file for class GtkView
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Model.h"
#include "GtkView.h"
#include "Speaker.h"

#include <string.h>
#include <stdio.h>
#include <time.h>


GtkView::GtkView(Model* m)
{
    speaker = new Speaker(this);
    
    setModel(m);
    
    numRows=0;
    rowSelect = -1;
    
    vbox = new Gtk_VBox(FALSE, 0);
    set_default_size(444, 600);
    set_title("xcallerid");
    set_policy(TRUE,TRUE,FALSE);
    
    accelGroup = new Gtk_AccelGroup();
    
    itemFactory = new Gtk_ItemFactory_MenuBar("<Main>", *accelGroup);
    itemFactory->create_item("/File", 0, "<Branch>", 0);  
    itemFactory->create_item("/File/Quit", "<control>Q", "<Item>", ItemFactoryConnector<GtkView,string>(this,&fileCallback,"Quit"));
    
    itemFactory->create_item("/Edit", 0, "<Branch>", 0);  
    //itemFactory->create_item("/Edit/View", "<control>L", "<Item>", ItemFactoryConnector<GtkView,string>(this,&folderCallback,"View"));
    itemFactory->create_item("/Edit/Edit Name", "<control>N", "<Item>", ItemFactoryConnector<GtkView,string>(this,&editCallback,"Edit Name"));
    itemFactory->create_item("/Edit/Edit Greeting", "<control>G", "<Item>", ItemFactoryConnector<GtkView,string>(this,&editCallback,"Edit Greeting"));
    itemFactory->create_item("/Edit/Play Greeting", "<control>P", "<Item>", ItemFactoryConnector<GtkView,string>(this,&editCallback,"Play Greeting"));
    itemFactory->create_item("/Edit/Record Greeting", "<control>R", "<Item>", ItemFactoryConnector<GtkView,string>(this,&editCallback,"Record Greeting"));
    
    itemFactory->create_item("/Search", 0, "<Branch>", 0);  
    itemFactory->create_item("/Search/Search by Date", "<control>D", "<Item>", ItemFactoryConnector<GtkView,string>(this,&searchCallback,"Search by Date"));
    itemFactory->create_item("/Search/Search by Name", "<control>M", "<Item>", ItemFactoryConnector<GtkView,string>(this,&searchCallback,"Search by Name"));
    itemFactory->create_item("/Search/Search by Number", "<control>B", "<Item>", ItemFactoryConnector<GtkView,string>(this,&searchCallback,"Search by Number"));
    
    itemFactory->create_item("/Daemon", 0, "<Branch>", 0);  
    itemFactory->create_item("/Daemon/Start Daemon", "<control>S", "<Item>", ItemFactoryConnector<GtkView,string>(this,&daemonCallback,"Start Daemon"));
    itemFactory->create_item("/Daemon/Stop Daemon", "<control>T", "<Item>", ItemFactoryConnector<GtkView,string>(this,&daemonCallback,"Stop Daemon"));
    
    itemFactory->create_item("/Help", 0, "<LastBranch>", 0);  
    itemFactory->create_item("/Help/About", "<control>H", "<Item>", ItemFactoryConnector<GtkView,string>(this,&helpCallback,"About"));
    
    add_accel_group(*accelGroup);
    
    vbox->pack_start(itemFactory->get_menubar_widget("<Main>"), FALSE, TRUE, 0);
    
    char* titles[] = {"Number","Name","Date","Time"};
    
    callList = new Gtk_CList(4,(const gchar**)titles);
    for(int i=0;i<4;i++) {
	callList->set_column_justification(i,GTK_JUSTIFY_CENTER);
    }
    callList->set_column_width(0,100);
    callList->set_column_width(1,150);
    callList->set_column_width(2,80);
    callList->set_column_width(3,60);
    callList->set_selection_mode(GTK_SELECTION_SINGLE );
    
    updateView();
    
    callListWin = new Gtk_ScrolledWindow();
    callListWin->set_policy(GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);  
    
    callListWin->add(callList);
    vbox->pack_start(*callListWin, TRUE, TRUE, 0);
    add(*vbox);
        
    connect_to_method(callList->select_row, this, &selectionMade);
    connect_to_method(callList->unselect_row, this, &selectionMade);
    
    show_all();
    
}

void GtkView::destroy() 
{
    model->quitModel();
}


void GtkView::displayAbout() 
{ 
    display("xcallerid-2.2.2 (c) 1999", "Joe Yandle <yandle@cs.unc.edu>", true, 0);
}

void GtkView::editNameCallback() 
{
    if(rowSelect == -1)
	return;
    
    Gtk_Dialog* aboutd;
    Gtk_Button* okbutton;
    Gtk_Button* cabutton;
    Gtk_Entry* name_entry;
    Gtk_HBox* hbox;
    
    hbox = new Gtk_HBox(TRUE,0);
    
    okbutton = new Gtk_Button("Ok");
    cabutton = new Gtk_Button("Cancel");
    aboutd = new Gtk_Dialog();
    
    //char num[64];
    _gtk_string num;
    callList->get_text(rowSelect,0,&num);
    
    char dtitle[256];
    sprintf(dtitle, "Edit name for %s", num.c_str());
    aboutd->set_title(dtitle);
    
    //char name[64];
    _gtk_string name;
    callList->get_text(rowSelect,1,&name);
    
    name_entry = new Gtk_Entry();
    name_entry->set_text(name.c_str());
    
    hbox->pack_start(*name_entry, FALSE, TRUE, 20);
    
    aboutd->get_vbox()->pack_start(*hbox, TRUE, TRUE, 10);
    aboutd->get_action_area()->pack_start(*okbutton,TRUE, TRUE, 25);
    aboutd->get_action_area()->pack_start(*cabutton,TRUE, TRUE, 25);
    aboutd->set_position(GTK_WIN_POS_CENTER);    
    okbutton->show();
    cabutton->show();
    name_entry->show();
    hbox->show();
    aboutd->show();
    
    connect_to_method(name_entry->activate,this,  &updateNameCallback, (Gtk_Entry*)name_entry);
    connect_to_method(okbutton->clicked,this, &updateNameCallback, (Gtk_Entry*)name_entry);
    connect_to_method(name_entry->activate, this, &killWidget, (Gtk_Widget*)aboutd);
    connect_to_method(okbutton->clicked, this, &killWidget, (Gtk_Widget*)aboutd);
    connect_to_method(cabutton->clicked, this, &killWidget, (Gtk_Widget*)aboutd);
}

void GtkView::updateNameCallback(Gtk_Entry* entry)
{
    //char* name;
    _gtk_string name;
    callList->get_text(rowSelect,0,&name);
    
    model->getDbase()->updateDbase("name", (char*)(entry->get_text().c_str()), "number", (char*)(name.c_str()));
    
    resetList();
}

void GtkView::editGreetCallback() 
{
    if(rowSelect == -1)
	return;
    
    Gtk_FileSelection* fdialog;
    
    //char* num;
    _gtk_string num;
    callList->get_text(rowSelect,0,&num);
    char dtitle[256];
    sprintf(dtitle, "Edit greeting for %s", num.c_str());
    fdialog = new Gtk_FileSelection(dtitle);
    
    fdialog->show();
    fdialog->set_position(GTK_WIN_POS_CENTER);

    connect_to_method(fdialog->get_ok_button()->clicked, this, &updateGreetCallback, (Gtk_FileSelection*)fdialog);
    connect_to_method(fdialog->get_selection_entry()->activate, this, &updateGreetCallback, (Gtk_FileSelection*)fdialog);
    connect_to_method(fdialog->get_cancel_button()->clicked, this, &killWidget, (Gtk_Widget*)fdialog);
}

void GtkView::updateGreetCallback(Gtk_FileSelection* data)
{
    //char* name;
    _gtk_string name;
    callList->get_text(rowSelect,0,&name);
    
    model->getDbase()->updateDbase("incoming", (char*)(data->get_filename().c_str()), "number", (char*)(name.c_str()));
    data->delete_self();
}

void GtkView::editPlayCallback()
{
    if(rowSelect == -1)
	return;
    
    //char* num;
    _gtk_string num;  
    callList->get_text(rowSelect,0,&num);
    
    model->getDbase()->lookupEntry("number",(char*)(num.c_str()));
    char** row = model->getDbase()->getRow();
    
    speaker->playWav(row[4]);
}


void GtkView::editRecordCallback()
{
    Gtk_FileSelection* fsel = new Gtk_FileSelection("Choose filename");
    
    connect_to_method(fsel->destroy, this, &killWidget, (Gtk_Widget*)fsel);
    connect_to_method(fsel->get_ok_button()->clicked, this, &recWav, (Gtk_FileSelection*)fsel);
    connect_to_method(fsel->get_ok_button()->clicked, this, &killWidget, (Gtk_Widget*)fsel);
    connect_to_method(fsel->get_cancel_button()->clicked, this, &killWidget, (Gtk_Widget*)fsel);
    fsel->set_position(GTK_WIN_POS_CENTER);    
    fsel->show();
}

void GtkView::recWav(Gtk_FileSelection* data)
{
    char* recFile = new char[256];
    strcpy(recFile, data->get_filename().c_str());
    
    Gtk_Dialog* dialog;
    Gtk_Button* recButton;
    Gtk_Button* stopButton;
    Gtk_Button* playButton;
    Gtk_HBox* hbox;
    Gtk_Button* okButton;
    Gtk_Button* caButton;
    
    char temp1[255], temp2[255];
    temp1[0]=0;
    temp2[0]=0;
    
    hbox = new Gtk_HBox(TRUE,5);
    
    recButton = new Gtk_Button("Record");
    recButton->show();
    hbox->pack_start(*recButton,true,true,10);
    
    stopButton = new Gtk_Button("Stop");
    stopButton->show();
    hbox->pack_start(*stopButton,true,true,10);
    
    playButton = new Gtk_Button("Play");
    playButton->show();
    hbox->pack_start(*playButton,true,true,10);
    
    hbox->show();
    
    connect_to_method(recButton->clicked, speaker, &Speaker::recWav, (char*)recFile);
    connect_to_method(stopButton->clicked, this, &stopRecCallback);
    connect_to_method(playButton->clicked, speaker, &Speaker::playWav, (char*)recFile);
    
    dialog = new Gtk_Dialog();
    dialog->get_vbox()->pack_start(*hbox,true,true,10);
    
    okButton = new Gtk_Button("Ok");
    caButton = new Gtk_Button("Cancel");
    
    dialog->set_title(recFile);
    dialog->set_position(GTK_WIN_POS_CENTER);

    dialog->get_action_area()->pack_start(*okButton,TRUE, TRUE, 25);
    dialog->get_action_area()->pack_start(*caButton,TRUE, TRUE, 25);
    
    okButton->show();
    caButton->show();
    
    connect_to_method(okButton->clicked, this, &killWidget, (Gtk_Widget*)dialog);
    connect_to_method(caButton->clicked, this, &killWidget, (Gtk_Widget*)dialog);
    
    dialog->show();
}

void GtkView::stopRecCallback()
{
    setRecOn(false);
}

/*
  void GtkView::fileCallback(string item)
*/
void GtkView::fileCallback(string item)
{
    if(item == "Quit") {
	destroy();
    }
}

/*
  void GtkView::editCallback(string item)
*/
void GtkView::editCallback(string item)
{
    if(item == "Edit Name") {
	editNameCallback();
    }
    else if(item == "Edit Greeting") {
	editGreetCallback();
    }
    else if(item == "Play Greeting") {
	editPlayCallback();
    }
    else if(item == "Record Greeting") {
	editRecordCallback();
    }
}

/*
  void GtkView::searchCallback(string item)
*/
void GtkView::searchCallback(string item)
{
    Gtk_Dialog* aboutd;
    Gtk_Button* okbutton;
    Gtk_Button* cabutton;
    Gtk_Entry* name_entry;
    Gtk_HBox* hbox;
    
    hbox = new Gtk_HBox(TRUE,0);
    okbutton = new Gtk_Button("Ok");
    cabutton = new Gtk_Button("Cancel");
    aboutd = new Gtk_Dialog();

    aboutd->set_title(item.c_str());
    aboutd->set_position(GTK_WIN_POS_CENTER);
    
    name_entry = new Gtk_Entry();
    
    hbox->pack_start(*name_entry, FALSE, TRUE, 20);
    
    
    aboutd->get_vbox()->pack_start(*hbox, TRUE, TRUE, 10);
    aboutd->get_action_area()->pack_start(*okbutton, TRUE, TRUE, 25);
    aboutd->get_action_area()->pack_start(*cabutton, TRUE, TRUE, 25);
    
    if(item == "Search by Date") {
	time_t now=time(NULL);
	char temp[64];
	model->getDbase()->getDate(now, temp);
	name_entry->set_text(temp);
	
	connect_to_method(okbutton->clicked, this, &searchDateUpdate, (Gtk_Entry*)name_entry);
	connect_to_method(name_entry->activate, this, &searchDateUpdate, (Gtk_Entry*)name_entry);
    }
    else if(item == "Search by Name") {
	connect_to_method(okbutton->clicked, this, &searchNameUpdate, (Gtk_Entry*)name_entry);
	connect_to_method(name_entry->activate, this, &searchNameUpdate, (Gtk_Entry*)name_entry);
    }
    else if(item == "Search by Number") {
	connect_to_method(okbutton->clicked, this, &searchNumbUpdate, (Gtk_Entry*)name_entry);
	connect_to_method(name_entry->activate, this, &searchNumbUpdate, (Gtk_Entry*)name_entry);
    }
    
    connect_to_method(okbutton->clicked, this, &killWidget, (Gtk_Widget*)aboutd);
    connect_to_method(name_entry->activate, this, &killWidget, (Gtk_Widget*)aboutd);
    connect_to_method(cabutton->clicked, this, &killWidget, (Gtk_Widget*)aboutd);
    
    aboutd->show_all();    
}

/*
  void GtkView::daemonCallback(string item)
*/
void GtkView::daemonCallback(string item)
{
    if(item == "Start Daemon") {
	model->startModel();
    }
    else if(item == "Stop Daemon") {
	model->stopModel();	
    }
}


/*
  void GtkView::helpCallback(string item)
*/
void GtkView::helpCallback(string item)
{
    if(item == "About") {
	displayAbout();
    }
}


void GtkView::searchDateUpdate(Gtk_Entry* data)
{
    sprintf(oldField, "call_date");
    sprintf(oldValue, data->get_text().c_str());
    resetList();
}

/*
  searchNameUpdate() 
*/
void GtkView::searchNameUpdate(Gtk_Entry* data)
{
    sprintf(oldField, "name");
    sprintf(oldValue, data->get_text().c_str());
    resetList();
}

/*
  searchNumbUpdate() 
*/
void GtkView::searchNumbUpdate(Gtk_Entry* data)
{
    sprintf(oldField, "number");
    sprintf(oldValue, data->get_text().c_str());
    resetList();
}

void GtkView::updateView()
{
    char today[64];
    time_t now = time(NULL);
    model->getDbase()->getDate(now, today);
    model->getDbase()->lookupEntry("call_date", today);
    
    while(numRows>0) {
	callList->remove_row(0);
	numRows--;
    }
    
    int n=0;
    while(model->getDbase()->moreRow()) {
	char** row = model->getDbase()->getRow();
	char* cdata[] = { row[0], row[1], row[2], row[3] };
	callList->append((const gchar**)cdata);
	n++;
    }
    numRows=n;
    rowSelect = -1;
    
    sprintf(oldField, "call_date");
    sprintf(oldValue, "%s", today);
}

void GtkView::resetList()
{
    
    model->getDbase()->lookupEntry(oldField, oldValue);
    
    while(numRows>0) {
	callList->remove_row(0);
	numRows--;
    }
    
    int n=0;
    while(model->getDbase()->moreRow()) {
	char** row = model->getDbase()->getRow();
	char* cdata[] = { row[0], row[1], row[2], row[3] };
	callList->append((const gchar**)cdata);
	n++;
    }
    numRows = n;
}


void GtkView::selectionMade(gint row, gint column, GdkEvent* button)
{
    rowSelect = row;
}


void GtkView::selectionLost(gint row, gint column, GdkEvent* button)
{
    rowSelect = -1;
}


void GtkView::handleEvents()
{
    while (gtk_events_pending())
	gtk_main_iteration();
}

void GtkView::display(char* msg1, char* msg2, bool isMsg, double pause)
{
    
    Gtk_Dialog* dialog;
    Gtk_Label* label1;
    Gtk_Label* label2;
    Gtk_VBox* vbox;
    Gtk_HBox* hbox1;
    Gtk_HBox* hbox2;
    Gtk_Button* okbutton;
    Gtk_Button* cabutton;
    
    char temp1[64], temp2[64];
    
    if(!isMsg) {
	sprintf(temp1,"Caller: %s",msg1);
	if(msg2) {
	    sprintf(temp2,"Number: %s",msg2);
	}
    }
    else {
	sprintf(temp1,"%s",msg1);
	if(msg2) {
	    sprintf(temp2,"%s",msg2);
	}   
    }
    
    vbox = new Gtk_VBox(FALSE,5);
    
    label1 = new Gtk_Label(temp1);
    label1->show();
    hbox1 = new Gtk_HBox(FALSE,10);
    hbox1->pack_start(*label1,false,true,10);
    hbox1->show();
    if(msg2) {
	label2 = new Gtk_Label(temp2);
	label2->show();
	hbox2 = new Gtk_HBox(FALSE,10);
	hbox2->pack_start(*label2,false,true,10);
	hbox2->show();
    }
    
    dialog = new Gtk_Dialog();
    vbox->pack_start(*hbox1,false,true,0);
    if(msg2) {
	vbox->pack_start(*hbox2,false,true,0);
    }
    vbox->show();
    dialog->get_vbox()->pack_start(*vbox,true,true,10);
    dialog->set_position(GTK_WIN_POS_CENTER);
    
    okbutton = new Gtk_Button("Ok");
    cabutton = new Gtk_Button("Cancel");
    
    if(!isMsg)
	dialog->set_title("Incoming Call");
    
    dialog->get_action_area()->pack_start(*okbutton,TRUE, TRUE, 25);
    dialog->get_action_area()->pack_start(*cabutton,TRUE, TRUE, 25);
    
    okbutton->show();
    cabutton->show();
    
    if(pause>0) {
	connect_to_method(Gtk_Main::timeout(1000*pause), this, &killWidgetCallback, (Gtk_Widget*)dialog);
    }
    else {
	connect_to_method(okbutton->clicked, this, &killWidget, (Gtk_Widget*)dialog);
	connect_to_method(cabutton->clicked, this, &killWidget, (Gtk_Widget*)dialog);
    }
    
    dialog->show();
}


void GtkView::killWidget(Gtk_Widget* data)
{
    data->delete_self();
}


int GtkView::killWidgetCallback(Gtk_Widget* data)
{
    killWidget(data);
    return 0;
}


bool GtkView::getRecOn()
{
    return recOn;
}


void GtkView::setRecOn(bool on)
{
    recOn = on;
}

void GtkView::setModel(Model* m)
{
    model = m;
}

gint GtkView::delete_event_impl(GdkEventAny *)
{
    model->quitModel();
    return 0;
}

void GtkView::speakWav(char* wav)
{
    speaker->playWav(wav);
}
