/*
 * GtkModel.h - header file for class GtkModel
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * This class implements the abstract class Model, using Gtk_Main
 * as one of its base classes.  This allows a seamless integration 
 * with class GtkView.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef GTKMODEL_H
#define GTKMODEL_H

#include "Model.h"

#include <gtk--.h>

class GtkModel : public Gtk_Main, public Model
{
 public:
  GtkModel(int argc, char** argv);
  virtual Dbase* getDbase();
  virtual void setView(View* v);
  virtual void startModel();
  virtual void stopModel();
  virtual void runModel();
  virtual void quitModel();
 private:
  void inputCallback();
  gint timeoutCallback();
  void update(char* cname, char* cnmbr);

  int fd;
  int inputTag;
};

#endif
