/*
 * GtkModel.C - source file for class GtkModel
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "View.h"
#include "GtkModel.h"

#ifdef MSQL_DBASE
#include "MsqlDbase.h"
#endif
#ifdef MYSQL_DBASE
#include "MysqlDbase.h"
#endif
#ifdef PGSQL_DBASE
#include "PgsqlDbase.h"
#endif

#ifdef STD_MODEM
#include "StdModem.h"
#endif
#ifdef ISDN_MODEM
#include "IsdnModem.h"
#endif

#ifdef REGION_USA
#include "RegionUSA.h"
#endif
#ifdef REGION_ISDN
#include "RegionIsdn.h"
#endif

#include <stdio.h>

GtkModel::GtkModel(int argc, char** argv)
  : Gtk_Main(argc,argv)
{
#ifdef MSQL_DBASE
  dbase = new MsqlDbase();
#endif
#ifdef MYSQL_DBASE
  dbase = new MysqlDbase();
#endif
#ifdef PGSQL_DBASE
  dbase = new PgsqlDbase();
#endif

#ifdef STD_MODEM
  modem = new StdModem();
#endif
#ifdef ISDN_MODEM
  modem = new IsdnModem();
#endif

#ifdef REGION_USA
  region = new RegionUSA();
#endif
#ifdef REGION_ISDN
  region = new RegionIsdn();
#endif

  if(!modem->openPort()) {
    perror("Couldn't open modem");
    exit(1);
  }
  if(!dbase->openDbase()) {
    perror("Couldn't open database");
    exit(1);
  }

#ifdef ISDN_MODEM
  connect_to_method(Gtk_Main::timeout(100), this, &GtkModel::timeoutCallback);
#endif
#ifdef STD_MODEM
  connect_to_method(Gtk_Main::input(modem->getDes(),GDK_INPUT_READ), this, &GtkModel::inputCallback);
#endif
}

gint GtkModel::timeoutCallback()
{
  inputCallback();
  return true;
}

void GtkModel::inputCallback()
{
  if(modem->getDes() == -1)
    return;

  char buf[255];
  char callName[255];
  char callNmbr[255];

  bool haveName=false;
  bool haveNmbr=false;
  bool haveRing=false;

  modem->readLine(buf);

  /*
    if we're using an isdn4linux, we get everything in one lump string
  */
  if(region->isAllFields(buf)) {
    region->getName(buf, callName);
    region->getNmbr(buf, callNmbr);

    char** temp;
    if(dbase->lookupEntry("number",callNmbr)) {
      temp=dbase->getRow();
      strcpy(callName, temp[1]);
    }
    update(callName, callNmbr);
  }

  /*
    otherwise, look for a NAME or NMBR field.  when you find one, search 
    for the other until either you find it or you get to a RING.

    if you don't find the other field, set the string to "Unknown"
  */
  else if( (haveName=region->isNameField(buf)) || (haveNmbr=region->isNmbrField(buf)) ) {    
    if(haveName) {
      region->getName(buf, callName);
      while( !(haveNmbr=region->isNmbrField(buf)) && !(haveRing=region->isRing(buf)) ) {
	modem->readLine(buf);
      }
      if(haveNmbr) {
	 region->getNmbr(buf, callNmbr);
      }
      else {
	strcpy(callNmbr, "Unknown");
      }
    }
    else {
      region->getNmbr(buf, callNmbr);
      while( !(haveName=region->isNameField(buf)) && !(haveRing=region->isRing(buf)) ) {
	modem->readLine(buf);
      }
      if(haveName) {
	 region->getName(buf, callName);
      }
      else {
	strcpy(callName, "Unknown");
      }
    }

    /*
      now search for the number, and replace callName if necessay
    */
    char** temp;
    if(dbase->lookupEntry("number",callNmbr)) {
      temp=dbase->getRow();
      strcpy(callName, temp[1]);
    }
    update(callName, callNmbr);
  }
}

void GtkModel::update(char* cname, char* cnmbr)
{
  char** temp;
  char incoming[256];
  char announce[256];
  sprintf(announce, "%s/share/wav/incoming.wav", XCID_ROOT);
  dbase->lookupEntry("number",cnmbr);
  if(dbase->moreRow()) {
    temp=dbase->getRow();
    strcpy(incoming, temp[4]);
  }
  else {
    sprintf(incoming,"%s/share/wav/unknown.wav", XCID_ROOT); 
  }

  dbase->addEntry(cname, cnmbr, incoming);
  view->display(cname, cnmbr, false, 5);
  view->updateView();  
  view->speakWav(announce);
  view->speakWav(incoming);
}


Dbase* GtkModel::getDbase() 
{ 
  return dbase;
}

void GtkModel::setView(View* v)
{
  view = v;
}

void GtkModel::runModel()
{
  run();
}


void GtkModel::startModel()
{
  if(modem->getDes() == -1)
    modem->openPort();	
}


void GtkModel::stopModel()
{
  if(modem->getDes() != -1)
    modem->closePort();
}

void GtkModel::quitModel()
{
  quit();
}
