/*
 * Dbase.h - header file for class Dbase
 * Copyright (c) 1999 Joe Yandle <yandle@cs.unc.edu>
 *
 * Dbase is an abstract class that declares the functions a database
 * should be able to perform, in an implementation independent way.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef DBASE_H
#define DBASE_H

#include <time.h>

class Dbase
{
 public:
  virtual bool openDbase()=0;
  virtual bool lookupEntry(char* field, char* value)=0;
  virtual char** getRow()=0;
  virtual bool moreRow()=0;
  virtual void addEntry(char* name, char* nmbr, char* greet)=0;
  virtual void getDate(time_t t, char* buffer)=0;
  virtual void updateDbase(char* key1, char* val1, char* key2, char* val2)=0;
};

#endif
