#ifndef TTNEWS_H
#define TTNEWS_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qbutton.h>
#include <qdir.h>
#include <qpopupmenu.h>

#include "newsWidget.h"
#include "allNewsWidget.h"
#include "parseNews.h"
#include "newsTable.h"

class DesktopWidget : public QWidget
{
  Q_OBJECT 
 public:
  DesktopWidget(QWidget *parent=0, const char *name=0 );
  ~DesktopWidget();
  void showNews();
  void showAllArticles();
  void paintEvent( QPaintEvent * );

  QFile *windowMetricsFile;

 public slots:
  void prevButtonClicked(); 
  void nextButtonClicked(); 
  void allNewsButtonClicked();
  void firstItemButtonClicked();
  void readNewsButtonClicked();
  void nextNewsSourceButtonClicked();
  void switchNews(int);
  void helpClicked();
  int readNews();

 protected:
  void timerEvent( QTimerEvent * );
  void mousePressEvent ( QMouseEvent * );
  void moveEvent ( QMoveEvent * );
  void enterEvent(QEvent *);
  void leaveEvent(QEvent *);

 private:
  void checkMousePos();
  void showBody(bool);
  int parseCommand();

  // Attributes
  QPixmap backgroundImage;
  NewsWidget *newsBody;
  AllNewsWidget *allNewsBody;
  ParseNews *newsParser;
  QString newsFilenames;
  bool showingBody;

  int switchNewsTimer;
  int readNewsTimer;
  int getNewsTimer;
  int checkMouseTimer;
  int readCommandFileTimer;

  QButton *prevButton;
  QButton *nextButton;
  QButton *allNewsButton;
  QButton *quitButton;
  
  QFont headlineFont;

  QDir dirPath;

  QFile *commandFile;

  QPopupMenu *popup;

  NewsTable *table; // A pointer to the list of news.
};


#endif // DESKTOP_H








