/*
readConfig.c - Reads configuration, and returns a struct with config-options.

Authors: Simon Kgstrm
         Carl Smith
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
 
#include "config.h"
#include "readConfig.h"

SkinStruct *readSkinConfig (char *filename)
{
  FILE *inFile;		/* Configuration-file (text) */
  char *buf;
  char *strToValue;
  char *bufpos;
  char *endpos;
  int i=0;
  int j=0;
  int articleNr=0;
  SkinStruct *outSkinStruct = (SkinStruct*)calloc(1, sizeof(SkinStruct));
  
  /* Default values: */
  outSkinStruct->showQuitButton = 1;
  outSkinStruct->headlineXpos = 40;	
  outSkinStruct->headlineYpos = 40;
  outSkinStruct->headlineFontSize = 12;
  strcpy(outSkinStruct->headlineFontFamily, "helvetica");
  strcpy(outSkinStruct->headlineFontColor,"white");
  outSkinStruct->bodyXpos = 40;	
  outSkinStruct->bodyYpos = 40;
  outSkinStruct->bodyFontSize = 12;
  strcpy(outSkinStruct->bodyFontFamily, "helvetica");
  strcpy(outSkinStruct->bodyFontColor, "white");
  outSkinStruct->allNewsFontSize = 12;
  strcpy(outSkinStruct->allNewsFontFamily, "helvetica");
  strcpy(outSkinStruct->allNewsFontColor, "black");
  strcpy(outSkinStruct->allNewsListColor1, "grey53");
  strcpy(outSkinStruct->allNewsListColor2, "grey60");
   
  /* Init some variables. */
  if((inFile = fopen(filename, "rt")) == NULL)	/* rt = read text */
    {
      fprintf(stderr, "Could not read skin-config\nExiting...\n");
      return NULL;
    }
  buf = (char *) malloc(600);
  strToValue = (char *) malloc(300);
  /* Read the configuration-file. */
  while (!feof(inFile)) 
    {
      fscanf(inFile, "%[^\n]\n", buf);
      if (buf[0] != '#')
	{
	  if ((bufpos=(char*)(strstr (buf, "HeadlineXpos="))) != NULL)
	    {
	      strncpy (strToValue, bufpos+strlen ("HeadlineXpos="), 299);
	      outSkinStruct->headlineXpos = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "ShowQuitButton="))) != NULL)
	    {
	      strncpy (strToValue, bufpos+strlen ("ShowQuitButton="), 299);
	      if ( strstr(strToValue, "true") != NULL)
		outSkinStruct->showQuitButton = 1;
	      else 
		outSkinStruct->showQuitButton = 0;
	    }
	  if ((bufpos=(char*)(strstr (buf, "HeadlineYpos="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("HeadlineYpos="), 299);
	      outSkinStruct->headlineYpos = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "BodyXpos="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("BodyXpos="), 299);
	      outSkinStruct->bodyXpos = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "BodyYpos="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("BodyYpos="), 299);
	      outSkinStruct->bodyYpos = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "HeadlineFontFamily="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("HeadlineFontFamily="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->headlineFontFamily[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "HeadlineFontSize="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("HeadlineFontSize="), 299);
	      outSkinStruct->headlineFontSize = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "HeadlineFontColor="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("HeadlineFontColor="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->headlineFontColor[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "BodyFontFamily="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("BodyFontFamily="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->bodyFontFamily[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "BodyFontSize="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("BodyFontSize="), 299);
	      outSkinStruct->bodyFontSize = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "BodyFontColor="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("BodyFontColor="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->bodyFontColor[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "AllNewsFontFamily="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("AllNewsFontFamily="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->allNewsFontFamily[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "AllNewsFontSize="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("AllNewsFontSize="), 299);
	      outSkinStruct->allNewsFontSize = atoi (strToValue);	
	    }
	  if ((bufpos=(char*)(strstr (buf, "AllNewsFontColor="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("AllNewsFontColor="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->allNewsFontColor[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "AllNewsListColor1="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("AllNewsListColor1="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->allNewsListColor1[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "AllNewsListColor2="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("AllNewsListColor2="), 299);
	      for (i=0; i<299;i++)
		outSkinStruct->allNewsListColor2[i] = strToValue[i];
	    }



	}
    }	
  free(buf);
  free(strToValue);
  fclose(inFile);
  return outSkinStruct;
}

ConfigStruct *readConfig (char *filename)
{				/* Read configuration */
  FILE *inFile;		/* Configuration-file (text) */
  char *buf;
  char *strToValue;
  char *bufpos;
  char *endpos;
  int i=0;
  int j=0;
  int articleNr=0;
  ConfigStruct *outConfig = (ConfigStruct*)calloc(1, sizeof(ConfigStruct));

  /* Default values: */
  outConfig->switchNewsTime = 5;
  outConfig->readNewsTime = 3000;
  outConfig->getNewsTime = 3000;
  outConfig->checkMouseOverTime = 1000;
  outConfig->readCommandFileTime = 300;
  strcpy(outConfig->placement,"bottomright");
  strcpy(outConfig->skin,"default");
  strcpy(outConfig->showArticlePic,"true");
  strcpy(outConfig->showDefaultPic,"true");
  strcpy(outConfig->showArticleBody,"true");
  strcpy(outConfig->mouseClickShowArticle,"false");
  strcpy(outConfig->newsPath,"news.txt");


  /* Init some variables. */
  if((inFile = fopen(filename, "rt")) == NULL)	/* rt = read text */
    {
      fprintf(stderr, "Could not read config-file\nExiting...\n");
      return NULL;
    }
  buf = (char *) malloc(600);
  strToValue = (char *) malloc(600);
  /* Read the configuration-file. */
  while (!feof(inFile)) 
    {
      fscanf(inFile, "%[^\n]\n", buf);
      if (buf[0] != '#')
	{
	  if ((bufpos=(char*)(strstr (buf, "NewsPath="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("NewsPath="), 599);
	      for (i=0; i<599;i++)
		outConfig->newsPath[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "ShowArticlePic="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("ShowArticlePic="), 19);
	      for (i=0; i<19;i++)
		outConfig->showArticlePic[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "ShowArticleBody="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("ShowArticleBody="), 19);
	      for (i=0; i<19;i++)
		outConfig->showArticleBody[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "ShowDefaultPic="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("ShowDefaultPic="), 19);
	      for (i=0; i<19;i++)
		outConfig->showDefaultPic[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "SwitchNewsTime="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("SwitchNewsTime="), 299);
	      outConfig->switchNewsTime = atoi (strToValue);
	    }	
	  if ((bufpos=(char*)(strstr (buf, "ReadNewsFileTime="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("ReadNewsFileTime="), 299);
	      outConfig->readNewsTime = atoi (strToValue);
	    }
	  if ((bufpos=(char*)(strstr (buf, "GetNewsTime="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("GetNewsTime="), 299);
	      outConfig->getNewsTime = atoi (strToValue);
	    }
	  if ((bufpos=(char*)(strstr (buf, "CheckMouseOverTime="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("CheckMouseOverTime="), 299);
	      outConfig->checkMouseOverTime = atoi (strToValue);
	    }
	  if ((bufpos=(char*)(strstr (buf, "ReadCommandFile="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("ReadCommandFile="), 299);
	      outConfig->readCommandFileTime = atoi (strToValue);
	    }
	  if ((bufpos=(char*)(strstr (buf, "Skin="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("Skin="), 299);
	      for (i=0; i<299;i++)
		outConfig->skin[i] = strToValue[i];
	    }
	  if ((bufpos=(char*)(strstr (buf, "MouseClickShowArticle="))) != NULL) /* Read body */
	    {
	      strncpy (strToValue, bufpos+strlen ("MouseClickShowArticle="), 299);
	      for (i=0; i<299;i++)
		outConfig->mouseClickShowArticle[i] = strToValue[i];
	    }
	  
          if ((bufpos=(char*)(strstr (buf, "Placement="))) != NULL) /* Where to put the ticker */
            {
              strncpy (strToValue, bufpos+strlen ("Placement="), 299);
              for (i=0; i<299;i++)
                outConfig->placement[i] = strToValue[i];
            }
	  
	}
    }	
  free(buf);
  free(strToValue);
  fclose(inFile);
  return outConfig;
}


