/*
pixmapButton.cpp 99-05-19
Author: Simon Kgstrm

Generic class for pixmapped buttons, i.e buttons with pictures.
*/

#include <qbitmap.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qstring.h>

#include "config.h"
#include "pixmapButton.h"

/*
Class PixmapButton - ButtonWidgets with pixmaps
-----------------------------------------------
*/

/** Constructs a new pixmaps with filenames for the images to load.*/
PixmapButton::PixmapButton( QString normalImageFilename, QString pressedImageFilename, QWidget *parent) : QButton (parent)
{
  normalImage.load(normalImageFilename); // Loads the images.
  pressedImage.load(pressedImageFilename);
  setFixedSize (normalImage.width(), normalImage.height());
}

/** Destructs the pixmapButton object*/
PixmapButton::~PixmapButton()
{
}

//---------------------Methods------------------

/** Draw the button pixmap (differs if it's pressed down or not)*/
void PixmapButton::drawButton( QPainter *p )
{
  QPixmap offscreen( width(), height() );
  offscreen.fill(this,QPoint(0,0));
 
  if (isDown()) // Check if button is pressed.
    p->drawPixmap(0,0,pressedImage,0,0,-1,-1);
  else
    p->drawPixmap(0,0,normalImage,0,0,-1,-1);

  bitBlt( this, 0, 0 , &offscreen ); // Draw button
}

