/*
parseNews.cpp 99-06-06
Authors: Simon Kgstrm
         Carl Smith
Class for reading a generic news-file. Format :
NEWSSOURCE:The name of the newssource (eg. BBC)
...
DATE:Date of Article
TIME:Time of Article
TITLE:Title of article
COLOUR:text colour to display in
URL:Url of related information
IMAGE:Image file that may be displayed
TEXT:This article is about the problems in QT with ...
...
TEXT:..Which are easily solved using ...

A DATE: line makes a new article
Only DATE is mandatory. NEWSSOURCE is needed only once in the top of the
news file.
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "config.h"
#include "parseNews.h"
#include "newsItem.h"
#include "newsTable.h"

/*
Class ParseNews - Read the generic news-file. Format above.
-----------------------------------------------------------
*/
ParseNews::ParseNews (QString filename)
{
  newsFile = new QFile (filename);
}

/** Constructs a ParseNews object with a file to read from and a NewsTable*/
ParseNews::ParseNews (QString filename, NewsTable* tmp)
{
  newsFile = new QFile (filename);
  table = tmp;
}

/** Destructs the ParseNews object */
ParseNews::~ParseNews ()
{
  delete newsFile;
}

// ----------------------Methods--------------------------

/** Read the news-file */
int ParseNews::readNews()
{
  int count=0;
  NewsItem article;


  if (newsFile->size() == 0)
    return 1;
 
  if (!newsFile->open(IO_ReadOnly))
    return 1;

  QTextStream t (newsFile);
 
  while (!t.eof())
    {
      QString s = t.readLine();
      
      if ( s.find("DATE:",0) == 0 ) 
	{
	  if (count != 0)
	    {
	      article.setBody(article.getBody().stripWhiteSpace());
	      table->insert(article); // Insert the latest item.
	    }
	  article.setBody("");
	  article.setDate(s.simplifyWhiteSpace().right((s.simplifyWhiteSpace()).length()-5));
	  count++;
	}
      if ( s.find("NEWSSOURCE:",0) == 0 )
	  article.setNewsSource(s.simplifyWhiteSpace().right((s.simplifyWhiteSpace()).length()-11));
	
      if ( s.find("TIME:",0) == 0 ) 
	article.setTime(s.simplifyWhiteSpace().right((s.simplifyWhiteSpace()).length()-5));      
     
      if ( s.find("TITLE:",0) == 0 ) 
	article.setTitle(s.simplifyWhiteSpace().right((s.simplifyWhiteSpace()).length()-6));
      
      if ( s.find("COLOUR:",0) == 0 ) 
	article.setColour(s.simplifyWhiteSpace().right((s.simplifyWhiteSpace()).length()-7));
      
      if ( s.find("TEXT:",0) == 0 ) 
	article.appendBody(s.stripWhiteSpace().right((s.stripWhiteSpace()).length()-5)+"\n");
      
      if ( s.find("IMAGE:",0) == 0 ) 
	article.setPicture(s.simplifyWhiteSpace().right((s.simplifyWhiteSpace()).length()-6));
      
    }
 
  newsFile->close();
  
  table->getFirstArticle();
  
  return 0;
}













