/*
newsWidget.cpp 99-05-15
Authors: Simon Kagstrom
         Carl Smith
Displays the news-article (in TorgetArticle) in an own window.
*/

#include <qbitmap.h>
#include <qpainter.h>
#include <qapplication.h>
#include <qdir.h>
#include <qstring.h>
#include <stdio.h>

#include "config.h"
#include "newsWidget.h"
#include "readConfig.h"
#include "newsItem.h"

/*
Class NewsWidget - Displays the news body in a separate window.
---------------------------------------------------------------
*/
/** Constructs a new article body.*/
NewsWidget::NewsWidget( ConfigStruct *config, SkinStruct *inSkinConfig, NewsItem in, QWidget *parent, const char *name )
    : QWidget( parent, name, WStyle_Customize | WStyle_NoBorder | WStyle_Tool)
{
  skinConfig = inSkinConfig;
  bodyFont = QFont( skinConfig->bodyFontFamily, skinConfig->bodyFontSize);

  QString tempSkinPath = "skins/" + QString(config->skin).stripWhiteSpace() + "/";
  if(!(QFile(tempSkinPath)).exists()) // Else, use the one in the users home catalogue.
    tempSkinPath = QDir::homeDirPath()+"/.ttnews/skins/"+ QString(config->skin).stripWhiteSpace() + "/";
  if (!(QFile(tempSkinPath)).exists()) // Else, use the global one,
    tempSkinPath = QString(INSTALL_DIR)+"/skins/" + QString(config->skin).stripWhiteSpace() + "/";
  QString tempSkinSuffix = ".png";  // Look for png's by default.

  if (!QFile::exists(tempSkinPath+"bodyWindowMid"+tempSkinSuffix))
    tempSkinSuffix = ".bmp"; 
  
  if ((backgroundImageMid.load((tempSkinPath + "bodyWindowMid"+tempSkinSuffix)) == false) || (backgroundImageTop.load((tempSkinPath + "bodyWindowTop"+tempSkinSuffix)) == false) || (backgroundImageBottom.load((tempSkinPath + "bodyWindowBottom"+tempSkinSuffix)) == false))  // Not good, loaded every time the widget is created.
    {
      fprintf (stderr, "This skin is wrong! Could not load bodyWindow*.[png/bmp]\n");
      exit (2);
    }
  newsArticle = in;
  QString tst = QDir::homeDirPath()+"/.ttnews/data/"+newsArticle.getPicture();

  QString showArticleImage = config->showArticlePic;
  QString showDefaultPic = config->showDefaultPic;
  
  if (showArticleImage.stripWhiteSpace() == "true")
    {
      if (topicImage.load(tst) == false) {
	if (newsArticle.getPicture() == "NO_PIC") // User doesn't want pictures!
	  topicImage = QPixmap(); // Create NULL-pixmap.
	if ((showDefaultPic.stripWhiteSpace() == "true") && (topicImage.load(QDir::homeDirPath()+"/.ttnews/data/default.gif") == false))
	  topicImage = QPixmap(); // Create NULL-pixmap.
      }
    }
  else
    topicImage = QPixmap();
  QFontMetrics test (bodyFont);
  bodySize = test.boundingRect(0,0,backgroundImageMid.width()-topicImage.width(),5000,WordBreak,newsArticle.getBody());
  setFixedSize( backgroundImageMid.width(), bodySize.height()+test.height()+backgroundImageTop.height()+backgroundImageBottom.height() );  
}

/** Destructs the news body. */
NewsWidget::~NewsWidget ()
{
}

// -----------------------Methods------------------------------
/** Updates the article showed in the news body. */
void NewsWidget::update( NewsItem iart )
{
  newsArticle = iart; 
  QFontMetrics test (bodyFont);

  bodySize = test.boundingRect(0,0,backgroundImageMid.width()-topicImage.width(),5000,WordBreak,newsArticle.getBody());
  setFixedSize( backgroundImageMid.width(), bodySize.height()+test.height()+backgroundImageTop.height()+backgroundImageBottom.height() );
  repaint();
}

/** Paints the news body. */
void NewsWidget::paintEvent( QPaintEvent * )
{
  QPixmap offscreen( width(), height() );
  QPainter p;
 
  p.begin( &offscreen );
  
  p.setFont (bodyFont);

  if ( newsArticle.getColour().isEmpty()) { // Set the color for the news.
    p.setPen(skinConfig->bodyFontColor);
  } else {
    p.setPen(newsArticle.getColour().data());
  }

  p.drawPixmap(0,0,backgroundImageTop,0,0,-1,-1); // Draw the "header"-graphics
  int xoff=backgroundImageTop.height();
  int i=0;
  while (i*backgroundImageMid.height() < bodySize.height()+p.fontMetrics().height()) // Draw mid-graphics
    {
      p.drawPixmap(0,xoff,backgroundImageMid,0,0,-1,-1);
      xoff = xoff+backgroundImageMid.height();
      i++;
    }
  p.drawPixmap(0,offscreen.height()-backgroundImageBottom.height(),backgroundImageBottom,0,0,-1,-1); // Draw bottom-graphics
  p.drawPixmap(backgroundImageMid.width()-topicImage.width()-5,backgroundImageTop.height() ,topicImage,0,0,-1,-1);
  
  p.drawText( 5,p.fontMetrics().height(), newsArticle.getTitle());

  p.drawText( p.fontMetrics().width(newsArticle.getTitle())+20, p.fontMetrics().height(), newsArticle.getDate());
  p.drawText( p.fontMetrics().width(newsArticle.getTitle())+25+p.fontMetrics().width(newsArticle.getDate()), p.fontMetrics().height(), newsArticle.getTime());
  p.drawText( 5,p.fontMetrics().height()+10, width()-topicImage.width()-20, height()-p.fontMetrics().height()-10, AlignLeft | WordBreak, newsArticle.getBody());
  
  p.end();
  bitBlt( this, 0, 0 , &offscreen );
}








