/*
newsTable.cpp 99-11-26
Author: Simon Kgstrm

A table with all news articles. 
*/

#include "qstring.h"
#include "qlist.h"

#include "config.h"
#include "newsTable.h"

/** Create an empty newsTable */
NewsTable::NewsTable()
{
  newsList.setAutoDelete( true );
}

/** Delete the newsTable */
NewsTable::~NewsTable()
{
}

/** Insert a new NewsItem in*/
void NewsTable::insert(NewsItem in)
{
  NewsItem *tmp = new NewsItem(in);
  newsList.insert(newsList.count(),tmp);
}

/** Remove a NewsItem in*/
void NewsTable::remove(NewsItem in) // NOT IMPLEMENTED
{
}

/** Get the current news article */
NewsItem NewsTable::getCurrent()
{
  return *newsList.current();
}

/** Get the next, undisplayed news article */
NewsItem NewsTable::getNext()
{
  NewsItem* tmp = newsList.next();
  if (tmp == NULL) // move the pointer to next listpos.
    tmp = newsList.first();

  return *tmp;
}

/** Get the next, undisplayed news article */
NewsItem NewsTable::getPrev()
{
  NewsItem* tmp = newsList.prev();
  if (tmp == NULL) // move the pointer to prev listpos.
    tmp = newsList.last();

  return *tmp;
}

/** Skip to the next news source. Returns the nr of that newsItem.
*/
int NewsTable::getNextNewsSource()
{  
  NewsItem tmp = getCurrent();
  QString oldSrc=tmp.getNewsSource();
  while (tmp.getNewsSource() == oldSrc)
    tmp = getNext();
  return newsList.at();
}

/** Skip to the next news source in*/
int NewsTable::getNewsSource(QString in)
{
  NewsItem tmp = getCurrent();
  QString oldSrc=tmp.getNewsSource();
  if(oldSrc != in)
    {
      getNextNewsSource();
      while (tmp.getNewsSource() != in  && tmp.getNewsSource() == oldSrc)
	tmp = getNext();
    }
  return newsList.at();
}

/** Skip to the first news article*/
NewsItem NewsTable::getFirstArticle ()
{
  NewsItem* tmp = newsList.first();
  return *tmp;
}

/** Skip to the last news article */
NewsItem NewsTable::getLastArticle ()
{
  NewsItem* tmp = newsList.last();
  return *tmp;
}

/** Skip to the article in */
NewsItem NewsTable::getArticle (NewsItem in)
{
}

/** Returns the current news nr */
int NewsTable::currentNr ()
{
  return newsList.at();
}

/** Skip to the article nr.  */
NewsItem NewsTable::getArticleNr (int nr)
{
  if (nr < 0)
    return *newsList.first();
  NewsItem* tmp;
  tmp = newsList.at(nr);
  if (tmp == NULL)
    tmp = newsList.last();
  if (tmp == NULL) /* IMMENSE BUG-WARNING!!! */
    return NewsItem();  
  return *tmp;
}

/** Returns true if current is last item */
bool NewsTable::isLast ()
{
  return (newsList.at() == newsList.count()-1);
}

/** Returns true if table is empty */
bool NewsTable::isEmpty ()
{
  return newsList.isEmpty();
}

int NewsTable::compareItems()
{
  return 1;
}
