/*
  genericNews.cpp 99-06-06.
  Author: Simon Kgstrm

Generic class for news-items.
*/
#include <qstring.h>
#include <stdlib.h>
#include <stdio.h>

#include "config.h"
#include "newsItem.h"

/*
Class NewsItem - Storage class for news-items.
---------------------------------------------- 
*/
NewsItem::NewsItem(QString inDate, QString inTime, QString inTitle, QString inBody)
{
  date = inDate;
  time = inTime;
  title = inTitle;
  body = inBody.stripWhiteSpace();
  newsSource="UNKNOWN";
}

NewsItem::NewsItem()
{
  newsSource="UNKNOWN";
}

NewsItem::~NewsItem()
{
#ifdef DEBUG_INFO_ON
  printf ("%s\n",title.data());
#endif
}

// --------------------Methods----------------------------x
QString NewsItem::getDate()
{
  return date;
}

QString NewsItem::getTime()
{
  return time;
}

QString NewsItem::getTitle()
{
  return title;
}

QString NewsItem::getColour()
{
  return colour;
}

QString NewsItem::getBody()
{
  return body;
}

QString NewsItem::getPicture()
{
  return picture;
}

QString NewsItem::getNewsSource()
{
  return newsSource;
}

void NewsItem::setDate(QString inDate)
{
  date = inDate;
}

void NewsItem::setTime(QString inTime)
{
  time = inTime;
}

void NewsItem::setTitle(QString inTitle)
{
  title = inTitle;
}

void NewsItem::setColour(QString inColour)
{
  colour = inColour ;
}

void NewsItem::setNewsSource(QString inSource)
{
  newsSource = inSource.stripWhiteSpace();
}

void NewsItem::setBody(QString inBody)
{
  body = inBody;
}

void NewsItem::appendBody(QString inBody)
{
  body = body + inBody;
}

void NewsItem::setPicture(QString inPicture)
{
  picture = inPicture;
}








