/*
listItem.cpp 00-01-09
Authors: Simon Kagstrom

Defines items for storage in allNewsWidget. Inherits QListBoxItem.
*/

#include <qapplication.h>
#include <qpainter.h>
#include <qstring.h>
#include <qcolor.h>

#include "config.h"
#include "newsItem.h"
#include "listItem.h"

ListItem::ListItem(NewsItem a, QColor c1, QColor c2 )
{
  newsArticle = a;
  fontColor = c1;
  itemBgColor = c2;
}

void ListItem::paint( QPainter *p  )
{
  QFontMetrics fm = p->fontMetrics();
  p->setPen(fontColor);
  p->fillRect(0,0,QApplication::desktop()->width(),p->fontMetrics().height()*2+10,itemBgColor); // CHANGE
  p->drawText( 1, p->fontMetrics().height(), newsArticle.getDate() );
  p->drawText( 1, p->fontMetrics().height()*2, newsArticle.getTitle() );
}

int ListItem::height(const QListBox *lb ) const
{
  return lb->fontMetrics().height()*2+3;
}

int ListItem::width(const QListBox *lb ) const
{
  return lb->fontMetrics().width( text() ) + 6;
}
