/*
Class for reading news from Slashdot.org (www.slashdot.org). 99-06-11.
Author: Simon Kgstrm

Bygs:
* No time yet (included in date though)...
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "readNews.h"

/*
Class ReadSlashdot - Reads news from an lynx-dumped infile, outputs generic news.
------------------------------------------------------------------------------
*/
ReadNews::ReadNews ()
{
}

ReadNews::ReadNews (QString inFilename, QString outFilename )
{
  inFile = new QFile (inFilename);
  outFile = new QFile (outFilename);
}

ReadNews::~ReadNews ()
{
  delete inFile;
  delete outFile;
}

QString ReadNews::getForkCommand()
{
  return "lynx -nolist -reload -dump http://www.slashdot.org";
}

//------------------------Methods----------------------------
// Read the news-file
int ReadNews::generateNewsfile()
{
  int count=0;
  int searchIndex=-1;
  int waitCount=-1;
  int dateRow=-1;
  bool found=false;
  bool nonempty=false;
  QString date;
  QString time;
  QString title;
  QString body;
  QString articlePic;
  QString s;
  
  if (inFile->size()==0)
    return 1;
  if (!inFile->open(IO_ReadOnly))
    return 1;
  if (!outFile->open(IO_WriteOnly))
    return 2;

  QTextStream in (inFile);
  QTextStream out (outFile);
  out << "NEWSSOURCE:Slashdot.org\n";
  
  while ( (!in.eof()) && (found == false))
    {
      s = in.readLine();
      searchIndex = s.find("Andover.Net");
      if (searchIndex != -1) // Then read 2 lines more...
	{
	  found = true;
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();

	  while ( (!in.eof()) && ( !nonempty ))
	    {
	      s = in.readLine();
	      s = s.simplifyWhiteSpace();
	      if (s.isEmpty() == 0) 
		{
		  nonempty=true;
		}
	    }
	}
    }
  while (!in.eof() )
    {
      dateRow=0;
      if (count == 0) // Title
	{
	  title = s.simplifyWhiteSpace();
	}
      if (count == 2) // Date / Time
	{
	  int idx = (s.simplifyWhiteSpace()).find(" on ");
	  int idx2 = (s.simplifyWhiteSpace()).find(", @");
	  date = (s.simplifyWhiteSpace()).right((s.simplifyWhiteSpace()).length()-idx-4);
	  
	  idx = (s.simplifyWhiteSpace()).find("Posted by");
	  articlePic = ((s.simplifyWhiteSpace()).left(idx)).simplifyWhiteSpace() + ".gif";
	  idx = 0;		  
	}
      if ( (count == 3) && (s.find("EDT") != -1) ) 
	dateRow=1;
      if ((count >=4+dateRow) && (s.find("Read More...") == -1) )
	body = body+" "+s.simplifyWhiteSpace();
      
      if (s.find("Read More...") == -1)
	count++;
      else // Everything collected... Write to file.
	{
	  out << "DATE:"+date+"\n";
	  out << "TIME:SlashDot\n";
	  out << "TITLE:"+title+"\n";
	  out << "TEXT:"+body+"\n";
	  out << "IMAGE:"+articlePic+"\n";
	  body = "";
	  count = -1;
	  dateRow = 0;
	}
      s = in.readLine();
    }
  inFile->close();
  outFile->close();
  return 0;
}








