/*
Class for reading news from TT (www.torget.se/v2/tt). 99-06-06.
Author: Simon Kgstrm
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "readNews.h"

/*
Class readNews - Abstract class to inherit and implement.
---------------------------------------------------------
*/
ReadNews::ReadNews()
{
}

ReadNews::ReadNews (QString inFilename, QString outFilename )
{
  inFile = new QFile (inFilename);
  outFile = new QFile (outFilename);
}

ReadNews::~ReadNews ()
{
  delete inFile;
  delete outFile;
}

//------------------------Methods----------------------------

// Return the forkCommand
QString ReadNews::getForkCommand()
{
  return "lynx -reload -width 1000 -dump -nolist http://www.torget.se/v2/tt";
}

// Read the news-file
int ReadNews::generateNewsfile()
{
int count=0;
  int searchIndex=-1;
  int waitCount=-1;
  bool found=false;
  QString date;
  QString time;
  QString title;
  QString body;
  QString s;

  if (!inFile->open(IO_ReadOnly))
    return 1;
  if (!outFile->open(IO_WriteOnly))
    return 2;
  QTextStream in (inFile);
  QTextStream out (outFile);

  while (!in.eof() && !found)
    {
      s = in.readLine();
      searchIndex = s.find(" FRN TT");
      if (searchIndex != -1) // Then read 2 lines more...
	{
	  found = true;
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof())
	    s = in.readLine();
	  if (!in.eof())
	    s = in.readLine();
	}
    }
  while (!in.eof()) {

    // Date - time
    s = s.right(s.length()-s.find("]")-1);
    s = s.right(s.length()-s.find("]")-2);
    date = (s.left(10)).simplifyWhiteSpace();
    time = (s.right(5)).simplifyWhiteSpace();
    
    // Title
    if (!in.eof()) s = in.readLine();
    s = s.right(s.length()-s.find("]")-1);
    s = s.right(s.length()-s.find("]")-2);

    title = s.simplifyWhiteSpace();
    //    out << title+"\n";

    
    // Nothing on lext line
    if (!in.eof()) s = in.readLine();

    // Body
    if (!in.eof()) s = in.readLine();
    s = s.right(s.length()-s.find("]"));
    body = s.simplifyWhiteSpace();
    
    while ( !in.eof() && (s.find("(TT)") == -1)) {
      if (!in.eof()) s = in.readLine();
      s = s.right(s.length()-s.find("]"));
      body.append(" "+s.simplifyWhiteSpace());
    }
    if (!in.eof()) s = in.readLine();


    if ( !title.isEmpty() ) {
      out << "DATE:" + date + "\n";
      out << "TIME:" + time + "\n";
      out << "TITLE:" + title + "\n";
      out << "TEXT:" + body + "\n";
    }
  }
  
  inFile->close();
  outFile->close();
  return 0;
}


