/*
Class for reading news from www.rainews24.rai.it. 99-12-22.
Author: Simon Kgstrm
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "readNews.h"

/*
Class readNews - Abstract class to inherit and implement.
---------------------------------------------------------
*/
ReadNews::ReadNews()
{
}

/** Constructs a new ReadNews object. */
ReadNews::ReadNews (QString inFilename, QString outFilename )
{
  inFile = new QFile (inFilename);
  outFile = new QFile (outFilename);
}

ReadNews::~ReadNews ()
{
  delete inFile;
  delete outFile;
}

//------------------------Methods----------------------------

/** Return the forkCommand for rainews24 */
QString ReadNews::getForkCommand()
{
  return "lynx -reload -width 1000 -dump -nolist http://www.rainews24.rai.it/sito/categoria.asp?IDC=1"; 
}

/** Read the news-file */
int ReadNews::generateNewsfile()
{
  int count=0;
  int searchIndex=-1;
  int waitCount=-1;
  bool found=false;
  QString date;
  QString time;
  QString title;
  QString body;
  QString s;

  if (inFile->size()==0)
    return 1;
  if (!inFile->open(IO_ReadOnly))
    return 1;
  if (!outFile->open(IO_WriteOnly))
    return 2;  
  QTextStream in (inFile);
  QTextStream out (outFile);
  out << "NEWSSOURCE:RAI News 24 Italia\n";
  while ( (!in.eof()) && (found == false))
    {
      s = in.readLine();
      searchIndex = s.find("[spacer.gif] [spacer.gif]");
      if (searchIndex != -1) 
	{
	  found = true;
	  int count = 1;
	  while (!in.eof() && count <= 2)
	    {
	      s = in.readLine();
	      count++;
	    }
	}
    }
  bool finished = false;
  while (!in.eof() &! finished) {

    if (!in.eof()) 
      s = in.readLine();
    if ( s.simplifyWhiteSpace() == "Links" )
      finished = true;
    else if (s.simplifyWhiteSpace() == "[spacer.gif]")
      if (!in.eof()) 
	s = in.readLine();
    
    if (!finished)
      {
	bool tmp=false;
	// Date
	s = s.stripWhiteSpace();
	date = s.left(s.find(' '));

	s = s.right(s.length()-s.find(' ')-1);
	// time
	time = s.left(s.find(' '));
	s = s.right(s.length()-s.find(' '));

	// Title
	title = s.stripWhiteSpace();

	// Body
	if (!in.eof()) 
	  s = in.readLine();
	body = s.stripWhiteSpace();
	if (body == "[spacer.gif]")
	  tmp=true;
    
	if (!tmp)
	  {
	    out << "DATE:" + date + "\n";
	    out << "TIME:" + time + "\n";
	    out << "TITLE:" + title + "\n";
	    out << "TEXT:" + body + "\n";
	  }
	tmp = false;
      }
  }
  
  inFile->close();
  outFile->close();
  return 0;
}



