/*
Class for reading news from Linuxtoday.org (www.Linuxtoday.org). 99-06-11.
Author: Simon Kgstrm
hacked by Carl Smith to work with the new news format.

Bygs:
* No time yet (included in date though)...
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "readNews.h"

/*
Class ReadLinuxtoday - Reads news from an lynx-dumped infile, outputs generic news.
---------------------------------------------------------------------------------
*/
ReadNews::ReadNews()
{
}

ReadNews::ReadNews (QString inFilename, QString outFilename )
{
  inFile = new QFile (inFilename);
  outFile = new QFile (outFilename);
}

ReadNews::~ReadNews ()
{
  delete inFile;
  delete outFile;
}

//------------------------Methods----------------------------
// Return the forkCommand
QString ReadNews::getForkCommand()
{
  return "lynx -source -dump -reload http://linuxtoday.com/index.html";
}


// Read the news-file
int ReadNews::generateNewsfile()
{
  int count=0;
  int searchIndex=-1;
  int waitCount=-1;
  bool found=false;
  QString date="aa";
  QString time="bb";
  QString title;
  QString body;
  QString articlePic="cc";
  QString s;

  if (inFile->size()==0)
    return 1;
  if (!inFile->open(IO_ReadOnly))
    return 1;
  if (!outFile->open(IO_WriteOnly))
    return 2;

  QTextStream in (inFile);
  QTextStream out (outFile);
  out << "NEWSSOURCE:Linux Today\n";

  while (!in.eof() && (s.find("</TD><TD WIDTH=\"30%\" VALIGN=\"TOP\">") == -1))
    {
      s = in.readLine();
      if (s.contains("<A HREF=\"/story",false) != 0) // Found article...
	found = true;
      if (found == true)
	{
	  if (count == 1) // Title. Title until "</A>"
	    {
	      int endIndex = s.find ("</A>");
	      s.truncate(endIndex);
	      title = s.simplifyWhiteSpace();
	    }
	  
	  if (count == 3) // Date / Time
	    {
	      int idx = s.find("071482");
	      date = s.right(s.length()-idx-9).simplifyWhiteSpace();
	      date.truncate(date.find(")"));
	    }

	  /*
	    if (count == 3) // Date / Time
	    {
	    int beginIndex = s.find ("(");
	    //	      s.truncate(endIndex);  
	    }
	  */

	  if (count < 6)
	    count++;

	  if (count == 6) // Body
	    {
	      //	      int endIndex = s.find("<P>");
	      s.truncate (s.find("<P>"));
	      body = s.right(s.length()-4).simplifyWhiteSpace();
	      count = 0;
	      out << "DATE:"+date+"\n";
	      out << "TIME:LinuxToday\n";
	      out << "TITLE:"+title+"\n";
	      out << "TEXT:"+body+"\n";
	      body = "";
	      date = "";
	      found = false;
	    }
	}
    }

  if ( date != "" ) {
    s.truncate (s.find("<P>"));
    body = s.right(s.length()-4).simplifyWhiteSpace();
    count = 0;
    out << "DATE:"+date+"\n";
    out << "TIME:LinuxToday\n";
    out << "TITLE:"+title+"\n";
    out << "TEXT:"+body+"\n";
    body = "";
    date = "";
  }

  inFile->close();
  outFile->close();
  return 0;
}









