/*
  Class for reading news from Heise (www.heise.de). 99-09-19.
  Author: Simon Kgstrm
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "readNews.h"

/*
Class ReadTT - Reads news from an lynx-dumped infile, outputs generic news.
---------------------------------------------------------------------------
*/

ReadNews::ReadNews()
{
}

ReadNews::ReadNews (QString inFilename, QString outFilename )
{
  inFile = new QFile (inFilename);
  outFile = new QFile (outFilename);
}

ReadNews::~ReadNews ()
{
  delete inFile;
  delete outFile;
}

//------------------------Methods----------------------------

// Return the forkCommand
QString ReadNews::getForkCommand()
{
  return "lynx -reload -width 1000 -dump -nolist http://www.heise.de";
}
// Read the news-file
int ReadNews::generateNewsfile()
{
  int count=0;
  int searchIndex=-1;
  int waitCount=-1;
  bool found=false;
  QString date;
  QString time;
  QString title;
  QString body;
  QString s;

  if (inFile->size()==0)
    return 1;
  if (!inFile->open(IO_ReadOnly))
    return 1;
  if (!outFile->open(IO_WriteOnly))
    return 2;
  QTextStream in (inFile);
  QTextStream out (outFile);
  out << "NEWSSOURCE:Heise.de\n";

  while (!in.eof() && !found)
    {
      s = in.readLine();
      searchIndex = s.find("suche mit Fireball");
      if (searchIndex != -1) // Then read 2 lines more...
	{	
	  found = true;
	  if (!in.eof()) // CHANGE CHANGE CHANGE!!!
	    s = in.readLine();
	  if (!in.eof())
	    s = in.readLine();
	  s=s.simplifyWhiteSpace();
	  s=s.right(10);
	  date = s.simplifyWhiteSpace();
	}      
    }
  found = false;
  QString tmp1,tmp2;
  while (!in.eof() && found == false) {

    if (!in.eof()) s = in.readLine(); // between news.
    // Title
    if (!in.eof()) s = in.readLine();
    title = s.simplifyWhiteSpace();
    if (s.find("Weitere Meldungen im News-berblick") != -1)
      found = true;
    //    out << title+"\n";
    
    // Body
    if (!in.eof()) s = in.readLine();
    body = s.simplifyWhiteSpace();

    if ( !found ) {
      out << "DATE:" + date + "\n";
      //      out << "TIME:" + time + "\n";
      out << "TITLE:" + title + "\n";
      out << "TEXT:" + body + "\n";
    }
  }
  
  inFile->close();
  outFile->close();
  return 0;
}








