/*
Class for reading news from the BBC
Author: Carl Smith
(Shamelessly hacked from slashdotserver by Simon Kgstrm)

Bygs:
* No time yet (included in date though)...
*/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include "readNews.h"

/**
Class ReadNews - Reads news from an lynx-dumped infile, outputs generic news.
-----------------------------------------------------------------------------
*/
ReadNews::ReadNews()
{
}

ReadNews::ReadNews (QString inFilename, QString outFilename )
{
  inFile = new QFile (inFilename);
  outFile = new QFile (outFilename);
}

ReadNews::~ReadNews ()
{
  delete inFile;
  delete outFile;
}

//------------------------Methods----------------------------

/** Return the forkCommand */
QString ReadNews::getForkCommand()
{
  return "lynx -reload -nolist -source http://tickers.bbc.co.uk/tickerdata/story.xml";
}

/** Read the news-file */
int ReadNews::generateNewsfile()
{
  int count=0;
  int searchIndex=-1;
  int alert=-1;
  int waitCount=-1;

  QString StoryGroup;
  int  SGID;

  bool found=false;
  bool intConversion=false;

  QString date;
  QString time;
  QString title;
  QString body;
  QString articlePic;

  if (inFile->size()==0)
    return 1;
  if (!inFile->open(IO_ReadOnly))
    return 1;
  if (!outFile->open(IO_WriteOnly))
    return 2;
  QTextStream in (inFile);
  QTextStream out (outFile);
  out << "NEWSSOURCE:BBC\n";


  while (!in.eof())
    {
      QString s = in.readLine();

      if ( searchIndex= s.find("<story group=") == 0) {

	if ( s.mid(14,1).toInt(&intConversion) != SGID ) {
	  switch (SGID)
	    {
	    case 6:
	      title = "Weather";
	      break;
	    case 8:
	      title = "Finance";
	      break;
	    }
	}

	if ( (((title.length() > 0 ) && ( body.length() > 0 )) || 
	     ((title.length() > 0 ) && ( SGID == 7 ) )) && ( SGID != 9)  )
	  {
	    switch (SGID) 
	      {
	      case 1: 
		StoryGroup = "World News";
		break;
		
	      case 2:
		StoryGroup = "UK News";
		break;
		
	      case 3: 
		StoryGroup = "Sports";
		break;
		
	      case 4:
		StoryGroup = "Business";
		break;
		
	      case 5: 
		StoryGroup = "Sci-Tech";
		break;
		
	      case 6: 
		StoryGroup = "Weather";
		break;
		
	      case 7: 
		StoryGroup = "Travel";
		break;
		
	      case 8:
		StoryGroup = "Finance";
		break;
		
	      case 9: 
		StoryGroup = "Test Group";
		break;
	      }

	    if ( alert == -1 ) { 
	      out << "DATE:BBC " + StoryGroup + "\n";
	      out << "TIME:" + date + " - " +time + "\n";
	      out << "TITLE:" + title+"\n";
	      out << "TEXT:" + body + "\n";
	      title = "";
	      body = "";
	    }
	  }
	
	

	SGID = s.mid(14,1).toInt(&intConversion);
	alert = s.find("alert=\"yes\" ");

      }

      if ( s.find("<headline>") == 1) {
	s.truncate(s.find("</headline>"));
	if ( s.find("Last update at ") > 0 ) {
	  time = s.right(s.length() - 25);
	} else {
	  if ( (SGID == 6) || (SGID == 8) ) {
	    body.append(s.right(s.length()-11)+"\nTEXT:");
	  } else {
	    title = s.right(s.length()-11);
	  }
	}
      }
      if ( s.find("<abstract>") == 1) {
	s.truncate(s.find("</abstract>"));
	body = s.right(s.length()-11);
      }
    }

  if ( title != "" ) { 
    if ( alert == -1 ) { 
      out << "DATE:BBC " + StoryGroup + "\n";
      out << "TIME:" + date + " - " +time + "\n";
      out << "TITLE:" + title+"\n";
      out << "TEXT:" + body + "\n";
      title = "";
      body = "";
    }
  }

  inFile->close();
  outFile->close();
  return 0;
}








