/*
allNewsWidget.cpp 99-05-20 (?)
Author: Simon Kagstrom

Displays the all news-articles (in TorgetArticle) in an own window.
*/

#include <qbitmap.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qapplication.h>
#include <qlistbox.h>
#include <qdir.h>
#include <qstring.h>
#include <qevent.h>
#include <stdio.h>

#include "config.h"
#include "allNewsWidget.h"
#include "ttnews.h"
#include "readConfig.h"
#include "listItem.h"

/*
Class AllNewsWidget - Displays the news in a separate window.
-------------------------------------------------------------
*/
AllNewsWidget::AllNewsWidget( ConfigStruct *config, SkinStruct *inSkinConfig, NewsTable* inTable, QWidget *parent, const char *name )
    : QWidget( parent, name, WStyle_NormalBorder)
{
  skinConfig = inSkinConfig; // Move the config into listItem
  allNewsFont = QFont( skinConfig->allNewsFontFamily, skinConfig->allNewsFontSize );
  QString itemColor1 = skinConfig->allNewsListColor1; 
  QString itemColor2 = skinConfig->allNewsListColor2;

  setCaption(name);
  table = inTable;
  lb = new QListBox( this, "listBox" );
  lb->setFont(allNewsFont);
  int i = 0;

  int tmpNr = table->currentNr();
  NewsItem tmp = table->getFirstArticle();

  // Place all news in a table
  bool a = true;
  while (!table->isLast())
    {
      if (a)
	lb->insertItem(new ListItem(tmp, QColor(skinConfig->allNewsFontColor), QColor(itemColor1) ));
      else
	lb->insertItem(new ListItem(tmp, QColor(skinConfig->allNewsFontColor), QColor(itemColor2) ));
      a = !a;
      tmp = table->getNext();
    }
  if (a)
    lb->insertItem(new ListItem(table->getLastArticle(),  QColor(skinConfig->allNewsFontColor), QColor(itemColor1) ));
  else
    lb->insertItem(new ListItem(table->getLastArticle(), QColor(skinConfig->allNewsFontColor), QColor(itemColor2) ));
  table->getArticleNr(tmpNr);

  lb->resize(width(),height());
  connect(lb, SIGNAL(selected(int)), SLOT( selRecieved(int) ));
} 

AllNewsWidget::~AllNewsWidget ()
{
}

void AllNewsWidget::updateNews( NewsTable *inTab )
{
  table = inTab;
}

void AllNewsWidget::closeEvent( QCloseEvent *e )
{
  e->accept();
}

void AllNewsWidget::resizeEvent( QResizeEvent *e )
{
  lb->resize(width(),height());
}

void AllNewsWidget::selRecieved(int v)
{
  emit sel(v);
}


