/*   tm.h   */

#define MAXCHAR 80

#define NONE       0
#define LEFT       1
#define RIGHT     -1

#define HALT      -1

#define FALSE      0
#define TRUE       1

#define BLANK      ' '

typedef struct square {
    char          symbol ;
    struct square *next ;
    struct square *previous ;
} SQUARE ;

typedef struct rule {
    int         state ;
    char        symbol ;
    char        new_symbol ;
    int         shift ;
    int         new_state ;
    struct rule *next ;
} RULE ;


SQUARE   *next_square( SQUARE* ) ;
SQUARE   *prev_square( SQUARE* ) ;
RULE     *read_ruleset( char* ) ;
SQUARE   *read_tape( char* ) ;
int      print_tape( void ) ;
void     print_rule( RULE* ) ;

