# Tk interface code
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# file COPYING for full details.

from calcFuncs import *
from globals import *
from drag import *
import fonts

from math import *
from Tkinter import *
from tkSimpleDialog import Dialog
import tkMessageBox
import tkFileDialog
import string

class CalcBC(Dialog):

	"""Calculate a bullet ballistic coefficient"""

	def body(self, master):

		Label(master, text="Initial Range").grid(pady=2)
		Label(master, text="Initial Velocity").grid(pady=2)
		Label(master, text="Final Range").grid(pady=2)
		Label(master, text="Final Velocity").grid(pady=2)

		self.e = []
		values = [calcBC.x0, calcBC.v0, calcBC.x1, calcBC.v1]
		for i in range(0,len(values)):
			self.e.append(Entry(master, width=8))
			self.e[i].grid(row=i, col=1, pady=2)
			self.e[i].insert(0, values[i])

		if calcparam.units == ENGLISH:
			Label(master, text="[yds]").grid(row=0, col=2, pady=2)
			Label(master, text="[ft/s]").grid(row=1, col=2, pady=2)
			Label(master, text="[yds]").grid(row=2, col=2, pady=2)
			Label(master, text="[ft/s]").grid(row=3, col=2, pady=2)
		else:
			Label(master, text="[m]").grid(row=0, col=2, pady=2)
			Label(master, text="[m/s]").grid(row=1, col=2, pady=2)
			Label(master, text="[m]").grid(row=2, col=2, pady=2)
			Label(master, text="[m/s]").grid(row=3, col=2, pady=2)

	def validate(self):

		try:
			temp = string.atof(self.e[0].get())
			temp = string.atof(self.e[1].get())
			temp = string.atof(self.e[2].get())
			temp = string.atof(self.e[3].get())
		except ValueError: return 0

		return 1

	def apply(self):

		calcBC.x0 = string.atof(self.e[0].get())
		calcBC.v0 = string.atof(self.e[1].get())
		calcBC.x1 = string.atof(self.e[2].get())
		calcBC.v1 = string.atof(self.e[3].get())

		self.destroy()

		# Calculate trajectory of standard bullet
		bullet.bc = 1.0
		firearm.v0 = calcBC.v0
		wind.x = wind.y = wind.z = 0.0
		calcparam.wx = calcparam.wy = calcparam.wz = 0.0

		print "Beginning Calculation"
		droparray(TRUE)
		from calcFuncs import *
		
		print "Calcualted Trajectory"

		# Find distance
		dist = calcBC.x1 - calcBC.x0
		if calcparam.units == ENGLISH:
			dist = dist * 3

		j = 1
		while j < calcparam.nstep and drop_array[1][j] < dist: j = j + 1

		# Get standard velocity
		vel = linint(drop_array[1][j-1], drop_array[0][j-1], drop_array[1][j], drop_array[0][j], dist)

		# Calculate BC
		bullet.bc = (calcBC.v0 - vel) / (calcBC.v0 - calcBC.v1)

		# Show BC
		tkMessageBox.showinfo("Calculated Ballistic Coefficient", "The B.C. is %.3f" % bullet.bc)

		# Update mainFrame
		mainFrame.entries()

		
class SelectBullet(Dialog):

	"""Select bullet from database"""

	def body(self, master):

		self.scrollbar = Scrollbar(master, orient=VERTICAL)
		self.listbox = Listbox(master, yscrollcommand=self.scrollbar.set, width=60, font=fonts.fixed)
		self.scrollbar.config(command=self.listbox.yview)
		self.scrollbar.pack(side=RIGHT, fill=Y)

		Label(master, text="D [in]     Description                  Weight [gr]    B.C.",
			  font=fonts.fixedbold).pack(side=TOP)
		file = open(bullet_file, 'r')

		# Skip first two lines
		file.readline()
		file.readline()

		line = string.rstrip(file.readline())
		while line != "":
			self.listbox.insert(END, line)
			line = string.rstrip(file.readline())

		file.close()

		self.listbox.bind("<Double-Button-1>", self.ok)
		self.listbox.pack(side=LEFT, fill=BOTH, expand=1)

	def validate(self):

		return 1

	def apply(self):

		item = self.listbox.curselection()
		if item:
			try:
				item = map(string.atoi, item)
			except ValueError: pass

			line = self.listbox.get(item[0])

			bullet.dia = string.atof(line[0:10])
			bullet.name = string.rstrip(line[11:40])
			if calcparam.units == METRIC:
				bullet.weight = string.atof(line[40:50]) * .06479891
			else:
				bullet.weight = string.atof(line[40:50])
			bullet.bc = string.atof(line[50:])
			
			mainFrame.entries()
		
		
class Config(Dialog):

	"""Global configuration dialog window"""

	def body(self, master):

		Label(master, text="Maximum Flight Time [s]",font=fonts.label).grid(row=0,sticky=E,pady=2)
		Label(master, text="Integration Points Per Second",font=fonts.label).grid(row=1,sticky=E,pady=2)
		Label(master, text="Unit System",font=fonts.label).grid(row=2,sticky=E,pady=2)
		Label(master, text="Drag Model",font=fonts.label).grid(row=4,sticky=E,pady=2)

		self.e1 = Entry(master,width=8,font=fonts.entry)
		self.e1.grid(row=0,column=1,pady=2)
		self.e1.insert(0,calcparam.maxtime)

		self.e2 = Entry(master,width=8,font=fonts.entry)
		self.e2.grid(row=1,column=1,pady=2)
		self.e2.insert(0,calcparam.stepsize)

		self.units = IntVar()
		self.r1 = Radiobutton(master,text="English",font=fonts.label,variable=self.units,value=ENGLISH)
		self.r1.grid(row=2, column=1, sticky=W)
		self.r2 = Radiobutton(master,text="Metric",font=fonts.label,variable=self.units,value=METRIC)
		self.r2.grid(row=3,column=1,sticky=W)

		if calcparam.units == ENGLISH:
			self.r1.select()
		else:
			self.r2.select()
			
		self.drag = IntVar()
		labels = ["G1", "G2", "G5", "G6", "G7", "G8", "Ingalls", "British"]
		self.d = []
		for i in range(0, len(labels)):
			self.d.append(Radiobutton(master, text=labels[i],font=fonts.label,
						  variable=self.drag, value=i))
			self.d[i].grid(row=i+4,column=1,sticky=W)
		
		self.d[0].select()

	def validate(self):

		try:
			calcparam.maxtime = string.atof(self.e1.get())
			calcparam.stepsize = string.atof(self.e2.get())
		except ValueError:
			return 0

		return 1

	def apply(self):

		calcparam.maxtime = string.atof(self.e1.get())
		calcparam.stepsize = string.atof(self.e2.get())

		if self.units.get() == ENGLISH:
			calcparam.units = ENGLISH
		else:
			calcparam.units = METRIC

		if self.drag.get() == 0:
			bullet.drag = g1
		elif self.drag.get() == 1:
			bullet.drag = g2
		elif self.drag.get() == 2:
			bullet.drag = g5
		elif self.drag.get() == 3:
			bullet.drag = g6
		elif self.drag.get() == 4:
			bullet.drag = g7
		elif self.drag.get() == 5:
			bullet.drag = g8
		elif self.drag.get() == 6:
			bullet.drag = ingalls
		elif self.drag.get() == 7:
			bullet.drag = british

		mainFrame.units()
		

class Trajectory(Toplevel):

	def __init__(self, parent, title='Trajectory Table'):

		from Tkinter import _default_root
		from Tkinter import *
		from globals import *

		if not parent:
			parent = _default_root
					
		Toplevel.__init__(self,parent)
		self.transient(parent)
				
		if title:
			self.title(title)
			
		self.parent = parent
		self.grab_set()
		
		self.protocol('WM_DELETE_WINDOW',self.destroy)
		
		body = Frame(self)


		# do the calculation
		calctraj()
		from calcFuncs import *
		
		conv = cos(firearm.angle*pi/180.0)
				
		# Add column labels
		self.labels = ["Range", "Velocity", "Energy", "Mom.", "Path", "Zero",
					   "Drop", "Drift", "Time"]
		for i in range(0, len(self.labels)):
			Label(body, text=self.labels[i], font=fonts.fixedbold).grid(row=0, column=i, sticky=E)

				
		if calcparam.units == ENGLISH:
			self.labels = ["[yds]", "[ft/s]", "[ft.lbf]", "[ft.lb/s]", "[in]",
						   "[in]", "[in]", "[in]", "[s]"]
			for i in range(0, len(self.labels)):
				Label(body, text=self.labels[i], font=fonts.fixedbold).grid(row=1, column=i, sticky=E)
		else:
			self.labels = ["[m]", "[m/s]", "[kJ]", "[kg.m/s]", "[m]", "[m]",
						   "[m]", "[m]", "[s]"]
			for i in range(0, len(self.labels)):
				Label(body, text=self.labels[i], font=fonts.fixedbold).grid(row=1, column=i, sticky=E)
				
		# Write the results
		rows = 2
		self.table = [ [], [], [], [], [], [], [], [], [] ]
		for i in range(printparam.start, printparam.end+1, printparam.step):
			if calcparam.units == ENGLISH:
				i = i * 3		# Convert to feet

			# Get zero data
			j = 0
			while j < calcparam.nstep and zero_array[1][j] < i:
				j = j + 1
			
			t = linint(zero_array[1][j - 1], time_points[j - 1],
					   zero_array[1][j], time_points[j], i)
			zero = linint(time_points[j - 1], zero_array[3][j - 1],
						  time_points[j], zero_array[3][j], t)
			
			# Get drop data									
			j = 0
			while j < calcparam.nstep and drop_array[1][j] < i:
				j = j + 1
				
			t = linint(drop_array[1][j - 1], time_points[j - 1],
					   drop_array[1][j], time_points[j], i)
			drop = linint(time_points[j - 1], drop_array[3][j - 1],
						  time_points[j], drop_array[3][j], t)								

			# Get the path data
			j = 0
			while j < calcparam.nstep and velpos_array[1][j] < i * conv:
				j = j + 1
				
			t = linint(velpos_array[1][j - 1], time_points[j - 1],
					   velpos_array[1][j], time_points[j], i * conv)
			Vx = linint(time_points[j - 1], velpos_array[0][j - 1],
						time_points[j], velpos_array[0][j], t)
			x = linint(time_points[j - 1], velpos_array[1][j - 1],
					   time_points[j], velpos_array[1][j], t)
			Vy = linint(time_points[j - 1], velpos_array[2][j - 1],
						time_points[j], velpos_array[2][j], t)
			y = linint(time_points[j - 1], velpos_array[3][j - 1],
					   time_points[j], velpos_array[3][j], t)
			Vz = linint(time_points[j - 1], velpos_array[4][j - 1],
						time_points[j],velpos_array[4][j], t)
			z = linint(time_points[j - 1], velpos_array[5][j - 1],
					   time_points[j], velpos_array[5][j], t)
			V = sqrt(Vx*Vx + Vy*Vy + Vz*Vz)
			
			# Fix elevation angle
			path = y - x * tan(firearm.angle*pi/180.0)
			
			if calcparam.units == METRIC:
				E = .5 * V * V * bullet.weight / 1000.0 / 1000.0
				M = V * bullet.weight / 1000.0
			else:
				E = .5 * V * V * bullet.weight / 7000.0 / G_E
				M = V * bullet.weight / 7000.0
				x = x / 3.0
				path = path * 12.0
				z = z * 12.0
				drop = drop * 12.0
				zero = zero * 12.0
				
			# Convert to real distance
			x = x / conv

			self.labels = [x, V, E, M, path, zero, drop, z, t]
			for i in range(0, len(self.labels)):
				self.table[i].append(self.labels[i])

			for i in range(0, len(self.labels)):
				Label(body, text="%8.2f" % self.labels[i], font=fonts.fixed).grid(row=rows, column=i)
			
			# Back to yards
			if calcparam.units == ENGLISH:
				i = i / 3.0
				
			if j >= calcparam.nstep:
				break

			rows = rows + 1
		
		# Create menus
		trajMenu = Menu(self)
		
		# File save/quit
		saveMenu = Menu(trajMenu)
		saveMenu.add('command', label="Save", command=self.save)
		saveMenu.add('command', label="Close", command=self.destroy)
		
		# Font menu
		fontMenu = Menu(trajMenu)
		fontMenu.add("command",label="Large",command=fonts.large)
		fontMenu.add("command",label="Medium",command=fonts.medium)
		fontMenu.add("command",label="Small",command=fonts.small)
		
		trajMenu.add('cascade', label="File", menu=saveMenu)
		trajMenu.add("cascade",label="Fonts",menu=fontMenu)

		self.config(menu=trajMenu)

		body.pack(side=LEFT,fill=BOTH)

		self.wait_window(self)

	def save(self, event=None):

		"""Save the trajectory table to a file"""

		filename = tkFileDialog.asksaveasfilename(parent=self, filetypes=[("All Files", "*")])

		if filename == "":
			return
			
		f = open(filename, 'w')

		if calcparam.units == METRIC:
			f.write("# Minimum Range %.1f [m]\n" % printparam.start)
			f.write("# Maximum Range %.1f [m]\n" % printparam.end)
			f.write("# Step Size %.1f [m]\n" % printparam.step) 
			f.write("# Zero Range %.2f [m]\n" % firearm.zero)
			f.write("# Ballistic Coefficient %.3f\n" % bullet.bc)
			f.write("# Muzzle Velocity %.2f [m/s]\n" % firearm.v0)
			f.write("# Elevation Angle %.2f [deg]\n" % firearm.angle)
			f.write("# Bore-Sight Distance %.2f [m]\n" % firearm.height)
			f.write("# Crosswind %.2f [m/s]\n" % wind.z)
		else:
			f.write("# Minimum Range %.1f [yds]\n" % printparam.start)
			f.write("# Maximum Range %.1f [yds]\n" % printparam.end)
			f.write("# Step Size %.1f [yds]\n" % printparam.step) 
			f.write("# Zero Range %.2f [yds]\n" % firearm.zero)
			f.write("# Ballistic Coefficient %.3f\n" % bullet.bc)
			f.write("# Muzzle Velocity %.2f [ft/s]\n" % firearm.v0)
			f.write("# Elevation Angle %.2f [deg]\n" % firearm.angle)
			f.write("# Bore-Sight Distance %.2f [in]\n" % firearm.height)
			f.write("# Crosswind %.2f [ft/s]\n" % wind.z)

		f.write("#%7s %8s %8s %8s %8s %8s %8s %8s %8s" % ("Range", "Vel", "Energy",
				"Mom", "Path", "Zero", "Drop", "Drift", "Time"))
				
		for row in range(0, len(self.table[0])):
			for column in range(0, len(self.table)):
				f.write("%8.3f " % self.table[column][row])
			f.write("\n")

		f.close()
		
class MainFrame(Frame):

	def __init__(self,parent):
	
		frame = self.frame = Frame(parent)
			
		# Create the labels
		Label(frame, text="Load Parameters", font=fonts.header).grid(row=0, columnspan=3, pady=5)
		Label(frame, text='Bullet Name', font=fonts.label).grid(row=1, col=0, sticky=W, pady=2)
		Label(frame, text='Bullet Diameter', font=fonts.label).grid(row=2, col=0, sticky=W, pady=2)
		Label(frame, text='Ballistic Coefficient', font=fonts.label).grid(row=3, col=0, sticky=W, pady=2)
		Label(frame, text='Bullet Weight', font=fonts.label).grid(row=4, col=0, sticky=W, pady=2)
		Label(frame, text='Muzzle Velocity', font=fonts.label).grid(row=5, col=0, sticky=W, pady=2)

		Label(frame, text="Firearm Parameters", font=fonts.header).grid(row=6, columnspan=3, pady=5)
		Label(frame, text='Bore-Sight Distance', font=fonts.label).grid(row=7, col=0, sticky=W, pady=2)
		Label(frame, text='Zero Distance', font=fonts.label).grid(row=8, col=0, sticky=W, pady=2)

		Label(frame, text="Target Parameters", font=fonts.header).grid(row=0, col=3, columnspan=3, pady=5)
		Label(frame, text='Vital Zone', font=fonts.label).grid(row=1, col=3, sticky=W, pady=2)
		Label(frame, text='Firing Angle', font=fonts.label).grid(row=2, col=3, sticky=W, pady=2)
		Label(frame, text='Wind Velocity', font=fonts.label).grid(row=3, col=3, sticky=W, pady=2)
		Label(frame, text='Wind Angle', font=fonts.label).grid(row=4, col=3, sticky=W, pady=2)

		Label(frame, text="Output Parameters", font=fonts.header).grid(row=5, col=3, columnspan=3, pady=5)
		Label(frame, text='Starting Range', font=fonts.label).grid(row=6, col=3, sticky=W, pady=2)
		Label(frame, text='Ending Range', font=fonts.label).grid(row=7, col=3, sticky=W, pady=2)
		Label(frame, text='Step Size', font=fonts.label).grid(row=8, col=3, sticky=W, pady=2)

		# Create the entry fields
		self.e = []

		## COLUMN 1 ##		
		# Bullet Name
		self.e.append(Entry(frame, width=24, font=fonts.entry))
		self.e[0].grid(row=1,col=1,pady=2,columnspan=2,sticky=W)
		
		# Bullet Dia
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[1].grid(row=2,col=1,pady=2, sticky=W)
		self.e[1].bind("<KeyRelease>",self.verify_float)
		# B.C.
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[2].grid(row=3,col=1,pady=2, sticky=W)
		self.e[2].bind("<KeyRelease>",self.verify_float)
		# Weight
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[3].grid(row=4,col=1,pady=2, sticky=W)
		self.e[3].bind("<KeyRelease>",self.verify_float)
		# Muzzle Velocity
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[4].grid(row=5,col=1,pady=2, sticky=W)
		self.e[4].bind("<KeyRelease>",self.verify_float)
		# Bore-Sight Distance
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[5].grid(row=7,col=1,pady=2, sticky=W)
		self.e[5].bind("<KeyRelease>",self.verify_float)
		# Zero Distance
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[6].grid(row=8,col=1,pady=2, sticky=W)
		self.e[6].bind("<KeyRelease>",self.verify_float)
		
		## COLUMN 2 ##
		# Vital Zone
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[7].grid(row=1,col=4,pady=2, sticky=W)
		self.e[7].bind("<KeyRelease>",self.verify_float)
		# Firing Angle
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[8].grid(row=2,col=4,pady=2, sticky=W)
		self.e[8].bind("<KeyRelease>",self.verify_float)
		# Wind Velocity
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[9].grid(row=3,col=4,pady=2, sticky=W)
		self.e[9].bind("<KeyRelease>",self.verify_float)
		# Wind Angle
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[10].grid(row=4,col=4,pady=2, sticky=W)
		self.e[10].bind("<KeyRelease>",self.verify_float)
		# Starting Range
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[11].grid(row=6,col=4,pady=2, sticky=W)
		self.e[11].bind("<KeyRelease>",self.verify_float)
		# Ending Range
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[12].grid(row=7,col=4,pady=2, sticky=W)
		self.e[12].bind("<KeyRelease>",self.verify_float)
		# Step Size
		self.e.append(Entry(frame, width=8, font=fonts.entry))
		self.e[13].grid(row=8,col=4,pady=2, sticky=W)
		self.e[13].bind("<KeyRelease>",self.verify_float)

		# fill entry fields
		self.entries()
		
		self.init = TRUE
		self.units()
		self.init = FALSE
		
	    # Display frame
		frame.grid(padx=10,pady=10)
		# Apply values when leaving frame
		frame.bind('<Leave>',self.apply)

	def entries(self):

		self.e[0].delete(0,END)
		self.e[0].insert(0,str(bullet.name))
		self.e[1].delete(0,END)
		self.e[1].insert(0,str(bullet.dia))
		self.e[2].delete(0,END)
		self.e[2].insert(0,str(bullet.bc))
		self.e[3].delete(0,END)
		self.e[3].insert(0,str(bullet.weight))
		self.e[4].delete(0,END)
		self.e[4].insert(0,str(firearm.v0))
		self.e[5].delete(0,END)
		self.e[5].insert(0,str(firearm.height))
		self.e[6].delete(0,END)
		self.e[6].insert(0,str(firearm.zero))
		self.e[7].delete(0,END)
		self.e[7].insert(0,str(target.vitals))
		self.e[8].delete(0,END)
		self.e[8].insert(0,str(firearm.angle))
		self.e[9].delete(0,END)
		self.e[9].insert(0,str(wind.z))
		self.e[10].delete(0,END)
		self.e[10].insert(0,str(wind.angle))
		self.e[11].delete(0,END)
		self.e[11].insert(0,str(printparam.start))
		self.e[12].delete(0,END)
		self.e[12].insert(0,str(printparam.end))
		self.e[13].delete(0,END)
		self.e[13].insert(0,str(printparam.step))
		
	def units(self):

		"""Print appropriate units on main window"""

		if self.init == TRUE:
			self.u = []
			if calcparam.units == ENGLISH:

				self.u.append(Label(self.frame, text="[in]"))
				self.u[0].grid(row=2, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[grains]"))
				self.u[1].grid(row=4, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[ft/s]"))
				self.u[2].grid(row=5, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[in]"))
				self.u[3].grid(row=7, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[4].grid(row=8, column=2, sticky=W, pady=2)

				self.u.append(Label(self.frame, text="[in dia]"))
				self.u[5].grid(row=1, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[6].grid(row=2, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[ft/s]"))
				self.u[7].grid(row=3, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[8].grid(row=4, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[9].grid(row=6, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[10].grid(row=7, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[11].grid(row=8, column=5, sticky=W, pady=2)
				
			else:
				# Metric

				self.u.append(Label(self.frame, text="[m]"))
				self.u[0].grid(row=2, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[grams]"))
				self.u[1].grid(row=4, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m/s]"))
				self.u[2].grid(row=5, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[3].grid(row=7, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[4].grid(row=8, column=2, sticky=W, pady=2)

				self.u.append(Label(self.frame, text="[m dia]"))
				self.u[5].grid(row=1, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[6].grid(row=2, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m/s]"))
				self.u[7].grid(row=3, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[8].grid(row=4, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[9].grid(row=6, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[10].grid(row=7, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[11].grid(row=8, column=5, sticky=W, pady=2)			
		else:
			for i in range(1, len(self.u)):
				self.u[i].grid_forget()
				self.u[i].destroy()
			self.u = []
			if calcparam.units == ENGLISH:

				self.u.append(Label(self.frame, text="[in]"))
				self.u[0].grid(row=2, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[grains]"))
				self.u[1].grid(row=4, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[ft/s]"))
				self.u[2].grid(row=5, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[in]"))
				self.u[3].grid(row=7, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[4].grid(row=8, column=2, sticky=W, pady=2)

				self.u.append(Label(self.frame, text="[in dia]"))
				self.u[5].grid(row=1, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[6].grid(row=2, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[ft/s]"))
				self.u[7].grid(row=3, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[8].grid(row=4, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[9].grid(row=6, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[10].grid(row=7, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[yds]"))
				self.u[11].grid(row=8, column=5, sticky=W, pady=2)

			else:

				self.u.append(Label(self.frame, text="[m]"))
				self.u[0].grid(row=2, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[grams]"))
				self.u[1].grid(row=4, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m/s]"))
				self.u[2].grid(row=5, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[3].grid(row=7, column=2, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[4].grid(row=8, column=2, sticky=W, pady=2)

				self.u.append(Label(self.frame, text="[m dia]"))
				self.u[5].grid(row=1, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[6].grid(row=2, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m/s]"))
				self.u[7].grid(row=3, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[deg]"))
				self.u[8].grid(row=4, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[9].grid(row=6, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[10].grid(row=7, column=5, sticky=W, pady=2)
				self.u.append(Label(self.frame, text="[m]"))
				self.u[11].grid(row=8, column=5, sticky=W, pady=2)			
			
			 
	def verify_float(self, event=None):
		# Verify floating points.  If they aren't grab focus
		# and don't let go until they convert ok.
		try:
			temp = string.atof(event.widget.get())
			event.widget.grab_release()
		except ValueError:
			event.widget.grab_set_global()
			event.widget.focus_set()
			
	def apply(self, event=None):
	
		"""Set variables from the entry boxes"""
		try:
		    bullet.name = self.e[0].get()
		    bullet.dia = string.atof(self.e[1].get())
		    bullet.bc = string.atof(self.e[2].get())
		    bullet.weight = string.atof(self.e[3].get())
		    firearm.v0 = string.atof(self.e[4].get())
		    firearm.height = string.atof(self.e[5].get())
		    firearm.zero = string.atof(self.e[6].get())
		    target.vitals = string.atof(self.e[7].get())
		    firearm.angle = string.atof(self.e[8].get())
		    wind.z = string.atof(self.e[9].get())
		    wind.angle = string.atof(self.e[10].get())
		    wind.x = wind.z * cos(wind.angle * pi / 180.0)
		    wind.z = wind.z * sin(wind.angle * pi / 180.0)
		    printparam.start = string.atof(self.e[11].get())
		    printparam.end = string.atof(self.e[12].get())
		    printparam.step = string.atof(self.e[13].get())
		except ValueError: pass
			

def pointBlank():

	"""Determine the maximum zero distance for a given vital zone"""

	maxRange = calcPointBlank()
	
	if calcparam.units == ENGLISH:
		tkMessageBox.showinfo("Maximum Point Blank Range",
			"Zero Distance: %.1f [yds]\nMax. Point Blank: %.1f [yds]" % (calcparam.zero / 3.0, maxRange / 3.0))
	else:
		tkMessageBox.showinfo("Maximum Point Blank Range",
			"Zero Distance: %.1f [m]\nMax. Point Blank: %.1f [m]" % (calcparam.zero, maxRange))
	
	
def BCWindow():
	mywindow = CalcBC(root, title="Calculate Ballistic Coefficient")
			
def trajWindow():
	mywindow = Trajectory(root)

def configWindow():
	mywindow = Config(root, title="Global Configuration")

def selectBullet():
	mywindow = SelectBullet(root, title="Select Bullet")
			
def interface():
    # Setup main application window
    global root
    root = Tk()
    root.title("tkBallistic v%s" % (VERSION))

    # Initialize fonts
    fonts.init()

    # Create main menu
    mainMenu = Menu(root)

    # Create setup menu
    setupMenu = Menu(mainMenu)
    setupMenu.add('command', label='Global Config', command=configWindow)
    setupMenu.add('separator')
    setupMenu.add('command', label='Select Bullet', command=selectBullet)
    setupMenu.add('separator')
    setupMenu.add('command', command=root.quit, label='Quit')

    # Create calculate menu
    calcMenu = Menu(mainMenu)
    calcMenu.add('command', command=trajWindow, label='Trajectory')
    calcMenu.add('command',label='Ballistic Coefficient', command=BCWindow)
    calcMenu.add('command', label='Maximum Point Blank Range', command=pointBlank)

    # Create fonts menu
    fontMenu = Menu(mainMenu)
    fontMenu.add("command", command=fonts.large, label="Large")
    fontMenu.add("command", command=fonts.medium, label="Medium")
    fontMenu.add("command", command=fonts.small, label="Small")
    
    # Finish main menu
    mainMenu.add('cascade',label="Setup",menu=setupMenu)
    mainMenu.add('cascade',label="Calculate",menu=calcMenu)
    mainMenu.add("cascade",label="Fonts",menu=fontMenu)

    # Create the input frame
    global mainFrame
    mainFrame = MainFrame(root)

    # Enter main loop
    root.config(menu=mainMenu)
    root.mainloop()
