# Global Variables
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# file COPYING for full details.

# Change this to your appropriate installation directory
bullet_file = "d:/source/tkballistic/bullet.dat"

# Nothing after this point needs to be changed

VERSION=1.2

import drag

# Unit system
ENGLISH = 0
METRIC = 1

# Number of varibles
NVAR = 6

# Conversion variables
MTOE = 3.28083989501
ETOM = .3048
G_M = 9.81
G_E = 32.174

TRUE = 1
FALSE = 0

class Struct:
	pass
	
bullet = Struct()
bullet.bc = 1.0
bullet.weight = 100
bullet.drag = drag.g1
bullet.name = ""
bullet.dia = 1.0

wind = Struct()
wind.x = 0
wind.y = 0
wind.z = 0
wind.angle = 90

firearm = Struct()
firearm.v0 = 1000
firearm.angle = 0
firearm.height = 1.5
firearm.zero = 100

target = Struct()
target.vitals = 4

calcparam = Struct()
calcparam.maxtime = 4
calcparam.units = ENGLISH
calcparam.nstep = 1000
calcparam.stepsize = 100
calcparam.zero = 100
calcparam.zero_angle = 0
calcparam.wx = 0
calcparam.wy = 0
calcparam.wz = 0

printparam = Struct()
printparam.start = 0
printparam.end = 1000
printparam.step = 50

calcBC = Struct()
calcBC.x0 = 0
calcBC.v0 = 2000
calcBC.x1 = 100
calcBC.v1 = 1000


