# Font Selections
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# file COPYING for full details.

import tkFont

fixed = None
fixedbold = None
header = None
label = None
entry = None

def init():
    
    """Initialize Fonts"""
    
    global fixed
    global fixedbold
    global header
    global label
    global entry
    
    fixed = tkFont.Font(family="Courier")
    fixedbold = tkFont.Font(family="Courier",weight=tkFont.BOLD)
    
    header = tkFont.Font(family="Helvetica", weight=tkFont.BOLD)
    label = tkFont.Font(family="Helvetica",weight=tkFont.BOLD)
    entry = tkFont.Font(family="Helvetica")
    
    medium()
    
def large():
    
    """Large Fonts"""
    
    fixed.config(size=12)
    fixedbold.config(size=12)
    header.config(size=16)
    label.config(size=14)
    entry.config(size=14)
    
def medium():
    
    """Medium fonts"""
    
    fixed.config(size=10)
    fixedbold.config(size=10)
    header.config(size=14)
    label.config(size=12)
    entry.config(size=12)
    
def small():
    
    """Small fonts"""
    
    fixed.config(size=8)
    fixedbold.config(size=8)
    header.config(size=12)
    label.config(size=10)
    entry.config(size=10)
