# Bullet Drag Functions
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# file COPYING for full details.

from math import *

def g1(v):
	
	"""G1 drag function, computed from G1 test data by Joshua Weage"""

	from globals import *
			
	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1.0 / MTOE

	if v * convert > 3030:
		return unconvert * 0.000296635108154501 * pow(v*convert, 1.87252063407832)
	if v * convert > 1680:
		return unconvert * 0.00265008089051 * pow(v*convert, 1.59991739552902)
	if v * convert > 1370:
		return unconvert * 7.4943163444737e-05 * pow(v*convert, 2.07924007208305)
	if v * convert > 1188:
		return unconvert * 3.70259572966957e-08 * pow(v*convert, 3.13397627815142)
	if v * convert > 1102:
		return unconvert * 2.03819724134521e-12 * pow(v*convert, 4.51864414221529)
	if v * convert > 1002:
		return unconvert * 1.26894810865425e-14 * pow(v*convert, 5.24444510076256)
	if v * convert > 897:
		return unconvert * 2.50774278169392e-12 * pow(v*convert, 4.47699813972495)
	if v * convert > 815:
		return unconvert * 3.58554042439043e-09 * pow(v*convert, 3.40803262472929)
	if v * convert > 670:
		return unconvert * 1.64345495555904e-06 * pow(v*convert, 2.4945292265651)
	if v * convert > 171:
		return unconvert * 0.000104179611848886 * pow(v*convert, 1.85590504676905)
	return unconvert * 7.79067551784038e-05 * pow(v*convert, 1.91007352175472)


def ingalls(v):

	"""Ingalls drag function"""

	from globals import *
	
	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units ==  METRIC: 
		convert = MTOE
		unconvert = 1 / MTOE
	
	
	if v * convert > 2600:
		return unconvert * (  4.0648825E-03  * pow( v * convert ,  1.55 ))
	if v * convert > 1800:
		return unconvert * (  1.2479524E-03  * pow( v * convert ,  1.7 ))
	if v * convert > 1370:
		return unconvert * (  1.3160125E-04  * pow( v * convert ,  2.0 ))
	if v * convert > 1230:
		return unconvert * (  9.5697809E-08  * pow( v * convert ,  3.0 ))
	if v * convert > 970:
		return unconvert * (  6.3368148E-14  * pow( v * convert ,  5.0 ))
	if v * convert > 790:
		return unconvert * (  5.9353046E-08  * pow( v * convert ,  3.0 ))
	return unconvert * (  4.6761777E-05  * pow( v * convert ,  2.0 ))


def british(v):

	"""British drag function"""

	from globals import *
	
	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1 / MTOE
	
	if v * convert > 2600:
		return unconvert * (  15366E-07  * pow( v*convert ,  1.67 ))
	if v * convert > 2000:
		return unconvert * (  58495E-07  * pow( v*convert ,  1.5 ))
	if v * convert > 1460:
		return unconvert * (  59814E-08  * pow( v*convert ,  1.8 ))
	if v * convert > 1190:
		return unconvert * (  95408E-12  * pow( v*convert ,  3.0 ))
	if v * convert > 1040:
		return unconvert * (  23385E-22  * pow( v*convert ,  6.45 ))
	if v * convert > 840:
		return unconvert * (  59939E-12  * pow( v*convert ,  3.0 ))
	return unconvert * (  74422E-08  * pow( v*convert ,  1.6 ))


def g2(v):

	"""G2 drag function"""

	from globals import *

	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1 / MTOE
		
	if v * convert > 1674:
		return unconvert * (  0.0079470052136733  * pow( v*convert ,  1.36999902851493 ))
	if v * convert > 1172:
		return unconvert * (  0.00100419763721974  * pow( v*convert ,  1.65392237010294 ))
	if v * convert > 1060:
		return unconvert * (  7.15571228255369e-23  * pow( v*convert ,  7.91913562392361 ))
	if v * convert > 949:
		return unconvert * (  1.39589807205091e-10  * pow( v*convert ,  3.81439537623717 ))
	if v * convert > 670:
		return unconvert * (  0.000234364342818625  * pow( v*convert ,  1.71869536324748 ))
	if v * convert > 335:
		return unconvert * (  0.000177962438921838  * pow( v*convert ,  1.76877550388679 ))
	return unconvert * (  5.18033561289704e-05  * pow( v*convert ,  1.98160270524632 ))


def g5(v):

	"""G5 drag function"""

	from globals import *

	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1 / MTOE
	
	if v * convert > 1730:
		return unconvert * (  0.00724854775171929  * pow( v*convert ,  1.41538574492812 ))
	if v * convert > 1228:
		return unconvert * (  3.50563361516117e-05  * pow( v*convert ,  2.13077307854948 ))
	if v * convert > 1116:
		return unconvert * (  1.84029481181151e-13  * pow( v*convert ,  4.81927320350395 ))
	if v * convert > 1004:
		return unconvert * (  1.34713064017409e-22  * pow( v*convert ,  7.8100555281422 ))
	if v * convert > 837:
		return unconvert * (  1.03965974081168e-07  * pow( v*convert ,  2.84204791809926 ))
	if v * convert > 335:
		return unconvert * (  0.000109301593869823  * pow( v*convert ,  1.81096361579504 ))
	return unconvert * (  3.51963178524273e-05  * pow( v*convert ,  2.00477856801111 ))


def g6(v):

	"""G6 drag function"""

	from globals import *

	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1 / MTOE
		
	if v * convert > 3236:
		return unconvert * (  0.0455384883480781  * pow( v*convert ,  1.15997674041274 ))
	if v * convert > 2065:
		return unconvert * (  0.0716726184965377  * pow( v*convert ,  1.10704436538885 ))
	if v * convert > 1311:
		return unconvert * (  0.00166676386084348  * pow( v*convert ,  1.60085100195952 ))
	if v * convert > 1144:
		return unconvert * (  1.01482730119215e-07  * pow( v*convert ,  2.9569674731838 ))
	if v * convert > 1004:
		return unconvert * (  4.31542773103552e-18  * pow( v*convert ,  6.34106317069757 ))
	if v * convert > 670:
		return unconvert * (  2.04835650496866e-05  * pow( v*convert ,  2.11688446325998 ))
	return unconvert * (  7.50912466084823e-05  * pow( v*convert ,  1.92031057847052 ))


def g7(v):

	"""G7 drag function"""

	from globals import *

	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1 / MTOE
	
	if v * convert > 4200:
		return unconvert * (  1.29081656775919e-09  * pow( v*convert ,  3.24121295355962 ))
	if v * convert > 3000:
		return unconvert * (  0.0171422231434847  * pow( v*convert ,  1.27907168025204 ))
	if v * convert > 1470:
		return unconvert * (  0.00233355948302505  * pow( v*convert ,  1.52693913274526 ))
	if v * convert > 1260:
		return unconvert * (  0.000797592111627665  * pow( v*convert ,  1.67688974440324 ))
	if v * convert > 1110:
		return unconvert * (  5.71086414289273e-12  * pow( v*convert ,  4.3212826264889 ))
	if v * convert > 960:
		return unconvert * (  3.02865108244904e-17  * pow( v*convert ,  5.99074203776707 ))
	if v * convert > 670:
		return unconvert * (  7.52285155782535e-06  * pow( v*convert ,  2.1738019851075 ))
	if v * convert > 540:
		return unconvert * (  1.31766281225189e-05  * pow( v*convert ,  2.08774690257991 ))
	return unconvert * (  1.34504843776525e-05  * pow( v*convert ,  2.08702306738884 ))


def g8(v):

	"""G8 drag function"""

	from globals import *

	convert = 1.0
	unconvert = 1.0
	
	if calcparam.units == METRIC:
		convert = MTOE
		unconvert = 1 / MTOE
		
	if v * convert > 3571:
		return unconvert * (  0.0112263766252305  * pow( v*convert ,  1.33207346655961 ))
	if v * convert > 1841:
		return unconvert * (  0.0167252613732636  * pow( v*convert ,  1.28662041261785 ))
	if v * convert > 1120:
		return unconvert * (  0.00220172456619625  * pow( v*convert ,  1.55636358091189 ))
	if v * convert > 1088:
		return unconvert * (  2.0538037167098e-16  * pow( v*convert ,  5.80410776994789 ))
	if v * convert > 976:
		return unconvert * (  5.92182174254121e-12  * pow( v*convert ,  4.29275576134191 ))
	return unconvert * (  4.3917343795117e-05  * pow( v*convert ,  1.99978116283334 ))
							
