# Calculation functions
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# file COPYING for full details.

from globals import *
from math import *

# Arrays
vstart = []
drop_array = []
zero_array = []
velpos_array = []
time_points = []

def rungekutta(y, dydx, n, x, h, yout, d):
	
	"""Rungekutta integration routine"""
		
	oldn = 0
	halfstep = h * 0.5
	h6 = h / 6.0
	xmid = x + halfstep

	dy_mid = []
	dy_trial = []
	y_trial = []
    		
	for i in range(0,n):
		dy_mid.append(i)
		dy_trial.append(i)
		y_trial.append(y[i] + halfstep * dydx[i])
		
	d(xmid, y_trial, dy_trial)
	for i in range(0,n):
		y_trial[i] = y[i] + halfstep * dy_trial[i]
		
	d(xmid, y_trial, dy_mid)
	for i in range(0,n):
		y_trial[i] = y[i] + h * dy_mid[i]
		dy_mid[i] = dy_mid[i] + dy_trial[i]

	d(x+h, y_trial, dy_trial)
	for i in range(0,n):
		yout[i] = y[i] + h6 * (dydx[i] + dy_trial[i] + 2.0 * dy_mid[i])

def rkdumb(starta, x1, array, d):
	
	"""Simple minded integration driver"""

	vcopy = []
	vout = []
	dvcopy = []
	
	for i in range(0, NVAR):
		vout.append(i)
		dvcopy.append(i)
		vcopy.append(starta[i])
		array[i][0] = starta[i]
		
	time_points[0] = x1
	x = x1
	h = (calcparam.maxtime - x1) / calcparam.nstep
	
	for k in range(0,calcparam.nstep):
		d(x,vcopy,dvcopy)
		rungekutta(vcopy,dvcopy, NVAR, x, h, vout, d)
		
		x = x + h
		time_points[k+1] = x
		
		for i in range(0, NVAR):
			array[i][k+1] = vcopy[i] = vout[i]

def flightmodel(x, y, dydx):
	
	"""Simple bullet flight model"""

	u = sqrt( (y[0] + calcparam.wx) * (y[0] + calcparam.wx) +
              (y[2] + calcparam.wy) * (y[2] + calcparam.wy) +
              (y[4] + calcparam.wz) * (y[4] + calcparam.wz) )

	alfa = (y[0] + calcparam.wx) / u
	beta = (y[2] + calcparam.wy) / u
	gamma = (y[4] + calcparam.wz) / u
	
	r = bullet.drag(u) / bullet.bc
	
	dydx[0] = -r * alfa		# Vx
	dydx[1] = y[0]			# Sx
	if calcparam.units == ENGLISH:
		dydx[2] = -r * beta - G_E	# Vy
	else:
		dydx[2] = -r * beta - G_M
	dydx[3] = y[2]			# Sy
	dydx[4] = -r * gamma	# Vz
	dydx[5] = y[4]			# Sz
	
def linint(x0, y0, x1, y1, x):

	"""Linear interpolation function"""
	
	return (x - x0) * (y1 - y0) / (x1 - x0) + y0
	
def zeroin(tval, varray, array):

	"""Simple elevation angle calculator"""

	if calcparam.units == ENGLISH:
		zero = calcparam.zero * 3		# Convert to feet
	else:
		zero = calcparam.zero
	
	i = 1
	while i < calcparam.nstep and array[1][i] < zero: i = i + 1
	t = linint(array[1][i - 1], tval[i - 1], array[1][i], tval[i], zero)
	dx = linint(tval[i - 1], array[1][i - 1], tval[i], array[1][i], t)
	dy = linint(tval[i - 1], array[3][i - 1], tval[i], array[3][i], t)
	calcparam.zero_angle = calcparam.zero_angle + atan(-dy / dx)
	varray[2] = sin(calcparam.zero_angle) * firearm.v0
	varray[0] = cos(calcparam.zero_angle) * firearm.v0

def setupGlobals():

	"""Initialize the global calculation variables"""

	calcparam.nstep = calcparam.maxtime * calcparam.stepsize

	global vstart, drop_array, zero_array, velpos_array, time_points
	
	vstart = []			# Starting velocity position vector
	drop_array = []		# Matrix
	zero_array = []		# Matrix
	velpos_array = []	# Matrix
	for i in range(0,NVAR):
		vstart.append(0)
		drop_array.append(range(0,calcparam.nstep+1))
		zero_array.append(range(0,calcparam.nstep+1))		
		velpos_array.append(range(0,calcparam.nstep+1))

	time_points = []
	for i in range(0,calcparam.nstep+1):
		time_points.append(0)

def droparray(test):

	"""Calculate the bullet drop array"""

	if test:
		setupGlobals()

	# Starting time to 0 sec
	t0 = 0.0
	
	# Setup for drop array calculation		
	vstart = [firearm.v0,	# Vx (downrange)
			  0.0,		# Sx
			  0.0,		# Vy (vertical)
			  0.0,		# Sy
			  0.0,		# Vz (transverse)
			  0.0]		# Sz

	# Set wind to zero
	calcparam.wx = calcparam.wy = calcparam.wz = 0.0
	rkdumb(vstart, t0, drop_array, flightmodel)

						
def calctraj():
	
	"""Initialize and calculate trajectory tables"""

	setupGlobals()
	
	t0 = 0.0	# Start time at 0 sec

	# Calculate bullet drop array
	print "Beginning Calculation"
	droparray(FALSE)	

	# Setup for zero array calculation
	vstart[0] = firearm.v0
	vstart[1] = 0.0
	vstart[2] = 0.0
	if calcparam.units == ENGLISH:
		vstart[3] = -firearm.height / 12.0
	else:
		vstart[3] = -firearm.height
	vstart[4] = 0.0
	vstart[5] = 0.0

	print "Iteration 2"
	rkdumb(vstart, t0, zero_array, flightmodel)
	
	# Zero it twice
	calcparam.zero_angle = 0.0
	calcparam.zero = firearm.zero
	zeroin(time_points, vstart, zero_array)
	print "Iteration 3"
	rkdumb(vstart, t0, zero_array, flightmodel)

	zeroin(time_points, vstart, zero_array)
	print "Iteration 4"
	rkdumb(vstart, t0, zero_array, flightmodel)
	
	# Actual bullet flight
	calcparam.wx = wind.x
	calcparam.wy = wind.y
	calcparam.wz = wind.z

	vstart[0] = firearm.v0 * cos(firearm.angle*pi/180.0 +
								 calcparam.zero_angle)
	vstart[1] = 0.0
	vstart[2] = firearm.v0 * sin(firearm.angle*pi/180.0 +
								 calcparam.zero_angle)
	if calcparam.units == ENGLISH:
		vstart[3] = -firearm.height / 12.0
	else:
		vstart[3] = -firearm.height
	vstart[4] = 0.0
	vstart[5] = 0.0

	print "Final Iteration"
	rkdumb(vstart, t0, velpos_array, flightmodel)

def calcPointBlank():

	"""Calculate the maximum point blank range"""

	# First calculate the bullet drop
	print "Beginning Calculation"
	droparray(TRUE)

	# Convert vitals into correct units
	if calcparam.units == ENGLISH:
		maxOffset = target.vitals / 12.0 / 2.0	# inches to feet
		height = firearm.height / 12.0
	else:
		maxOffset = target.vitals / 2.0
		height = firearm.height

	# Determine the zero range
	i = 1
	while i < calcparam.nstep:
		tantheta = drop_array[3][i] / drop_array[1][i]
		j = 1
		zone = 0
		while zone < maxOffset and j < i:
			zone = drop_array[3][j] - tantheta * drop_array[1][j] - \
				height * (1.0 - drop_array[1][j] / drop_array[1][i])
			j = j + 1
		if zone > maxOffset:
			break						# Found the max zero range
		i = i + 1

	# Recalculate with new zero
	t0 = 0.0
	calcparam.zero_angle = 0.0
	calcparam.zero = drop_array[1][i]

	vstart = [firearm.v0,	# Vx (downrange)
		  0.0,		# Sx
		  0.0,		# Vy (vertical)
		  0.0,		# Sy
		  0.0,		# Vz (transverse)
		  0.0]		# Sz

	zeroin(time_points, vstart, drop_array)
	print "Iteration 2"
	rkdumb(vstart, t0, drop_array, flightmodel)

	# Determine the zero range
	i = 1
	while i < calcparam.nstep:
		tantheta = drop_array[3][i] / drop_array[1][i]
		j = 1
		zone = 0
		while zone < maxOffset and j < i:
			zone = drop_array[3][j] - tantheta * drop_array[1][j] - \
				height * (1.0 - drop_array[1][j] / drop_array[1][i])
			j = j + 1
		if zone > maxOffset:
			break						# Found the max zero range
		i = i + 1

	# Rezero
	calcparam.zero = drop_array[1][i]
		
	zeroin(time_points, vstart, drop_array)
	print "Final Step"
	rkdumb(vstart, t0, drop_array, flightmodel)

	# Determine the zero range
	i = 1
	while i < calcparam.nstep:
		tantheta = drop_array[3][i] / drop_array[1][i]
		j = 1
		zone = 0
		while zone < maxOffset and j < i:
			zone = drop_array[3][j] - tantheta * drop_array[1][j] - \
				height * (1.0 - drop_array[1][j] / drop_array[1][i])
			j = j + 1
		if zone > maxOffset:
			break						# Found the max zero range
		i = i + 1

	calcparam.zero = drop_array[1][i]
	
	# Determine the maximum point blank range
	j = i
	zone = 0
	while j < calcparam.nstep and zone < maxOffset:
			j = j + 1
			zone = - drop_array[3][j] + tantheta * drop_array[1][j] - \
				height * (drop_array[1][j] / drop_array[1][i] - 1.0)

	maxRange = drop_array[1][j]
	return maxRange
